/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lexmodelsv2.model.UtteranceSpecification;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class UtteranceSpecificationMarshaller {
    private static final MarshallingInfo<String> BOTALIASID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botAliasId").build();
    private static final MarshallingInfo<String> BOTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botVersion").build();
    private static final MarshallingInfo<String> LOCALEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("localeId").build();
    private static final MarshallingInfo<String> SESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionId").build();
    private static final MarshallingInfo<String> CHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channel").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mode").build();
    private static final MarshallingInfo<Date> CONVERSATIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("conversationStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> CONVERSATIONENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("conversationEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> UTTERANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utterance").build();
    private static final MarshallingInfo<Date> UTTERANCETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utteranceTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> AUDIOVOICEDURATIONMILLIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioVoiceDurationMillis").build();
    private static final MarshallingInfo<Boolean> UTTERANCEUNDERSTOOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utteranceUnderstood").build();
    private static final MarshallingInfo<String> INPUTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputType").build();
    private static final MarshallingInfo<String> OUTPUTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputType").build();
    private static final MarshallingInfo<String> ASSOCIATEDINTENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("associatedIntentName").build();
    private static final MarshallingInfo<String> ASSOCIATEDSLOTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("associatedSlotName").build();
    private static final MarshallingInfo<String> INTENTSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("intentState").build();
    private static final MarshallingInfo<String> DIALOGACTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dialogActionType").build();
    private static final MarshallingInfo<String> BOTRESPONSEAUDIOVOICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botResponseAudioVoiceId").build();
    private static final MarshallingInfo<String> SLOTSFILLEDINSESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slotsFilledInSession").build();
    private static final MarshallingInfo<String> UTTERANCEREQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utteranceRequestId").build();
    private static final MarshallingInfo<List> BOTRESPONSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botResponses").build();
    private static final UtteranceSpecificationMarshaller instance = new UtteranceSpecificationMarshaller();

    public static UtteranceSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(UtteranceSpecification utteranceSpecification, ProtocolMarshaller protocolMarshaller) {
        if (utteranceSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)utteranceSpecification.getBotAliasId(), BOTALIASID_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getBotVersion(), BOTVERSION_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getLocaleId(), LOCALEID_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getSessionId(), SESSIONID_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getChannel(), CHANNEL_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getMode(), MODE_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getConversationStartTime(), CONVERSATIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getConversationEndTime(), CONVERSATIONENDTIME_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getUtterance(), UTTERANCE_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getUtteranceTimestamp(), UTTERANCETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getAudioVoiceDurationMillis(), AUDIOVOICEDURATIONMILLIS_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getUtteranceUnderstood(), UTTERANCEUNDERSTOOD_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getInputType(), INPUTTYPE_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getOutputType(), OUTPUTTYPE_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getAssociatedIntentName(), ASSOCIATEDINTENTNAME_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getAssociatedSlotName(), ASSOCIATEDSLOTNAME_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getIntentState(), INTENTSTATE_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getDialogActionType(), DIALOGACTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getBotResponseAudioVoiceId(), BOTRESPONSEAUDIOVOICEID_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getSlotsFilledInSession(), SLOTSFILLEDINSESSION_BINDING);
            protocolMarshaller.marshall((Object)utteranceSpecification.getUtteranceRequestId(), UTTERANCEREQUESTID_BINDING);
            protocolMarshaller.marshall(utteranceSpecification.getBotResponses(), BOTRESPONSES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

