/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.logs.model.ExportTask;
import com.amazonaws.services.logs.model.transform.ExportTaskExecutionInfoJsonMarshaller;
import com.amazonaws.services.logs.model.transform.ExportTaskStatusJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ExportTaskJsonMarshaller {
    private static ExportTaskJsonMarshaller instance;

    public void marshall(ExportTask exportTask, JSONWriter jsonWriter) {
        if (exportTask == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (exportTask.getTaskId() != null) {
                jsonWriter.key("taskId").value((Object)exportTask.getTaskId());
            }
            if (exportTask.getTaskName() != null) {
                jsonWriter.key("taskName").value((Object)exportTask.getTaskName());
            }
            if (exportTask.getLogGroupName() != null) {
                jsonWriter.key("logGroupName").value((Object)exportTask.getLogGroupName());
            }
            if (exportTask.getFrom() != null) {
                jsonWriter.key("from").value((Object)exportTask.getFrom());
            }
            if (exportTask.getTo() != null) {
                jsonWriter.key("to").value((Object)exportTask.getTo());
            }
            if (exportTask.getDestination() != null) {
                jsonWriter.key("destination").value((Object)exportTask.getDestination());
            }
            if (exportTask.getDestinationPrefix() != null) {
                jsonWriter.key("destinationPrefix").value((Object)exportTask.getDestinationPrefix());
            }
            if (exportTask.getStatus() != null) {
                jsonWriter.key("status");
                ExportTaskStatusJsonMarshaller.getInstance().marshall(exportTask.getStatus(), jsonWriter);
            }
            if (exportTask.getExecutionInfo() != null) {
                jsonWriter.key("executionInfo");
                ExportTaskExecutionInfoJsonMarshaller.getInstance().marshall(exportTask.getExecutionInfo(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ExportTaskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ExportTaskJsonMarshaller();
        }
        return instance;
    }
}

