/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.TransportStream;

@SdkInternalApi
public class TransportStreamMarshaller {
    private static final MarshallingInfo<Integer> CHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channels").build();
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codec").build();
    private static final MarshallingInfo<String> FRAMERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frameRate").build();
    private static final MarshallingInfo<StructuredPojo> FRAMERESOLUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frameResolution").build();
    private static final MarshallingInfo<Integer> PID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pid").build();
    private static final MarshallingInfo<Integer> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final MarshallingInfo<Integer> SAMPLESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleSize").build();
    private static final MarshallingInfo<String> STREAMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamType").build();
    private static final TransportStreamMarshaller instance = new TransportStreamMarshaller();

    public static TransportStreamMarshaller getInstance() {
        return instance;
    }

    public void marshall(TransportStream transportStream, ProtocolMarshaller protocolMarshaller) {
        if (transportStream == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)transportStream.getChannels(), CHANNELS_BINDING);
            protocolMarshaller.marshall((Object)transportStream.getCodec(), CODEC_BINDING);
            protocolMarshaller.marshall((Object)transportStream.getFrameRate(), FRAMERATE_BINDING);
            protocolMarshaller.marshall((Object)transportStream.getFrameResolution(), FRAMERESOLUTION_BINDING);
            protocolMarshaller.marshall((Object)transportStream.getPid(), PID_BINDING);
            protocolMarshaller.marshall((Object)transportStream.getSampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)transportStream.getSampleSize(), SAMPLESIZE_BINDING);
            protocolMarshaller.marshall((Object)transportStream.getStreamType(), STREAMTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

