/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.RouteAnalysisCompletionReasonCode;
import com.amazonaws.services.networkmanager.model.RouteAnalysisCompletionResultCode;
import com.amazonaws.services.networkmanager.model.transform.RouteAnalysisCompletionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RouteAnalysisCompletion
implements Serializable,
Cloneable,
StructuredPojo {
    private String resultCode;
    private String reasonCode;
    private Map<String, String> reasonContext;

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public RouteAnalysisCompletion withResultCode(String resultCode) {
        this.setResultCode(resultCode);
        return this;
    }

    public RouteAnalysisCompletion withResultCode(RouteAnalysisCompletionResultCode resultCode) {
        this.resultCode = resultCode.toString();
        return this;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public RouteAnalysisCompletion withReasonCode(String reasonCode) {
        this.setReasonCode(reasonCode);
        return this;
    }

    public RouteAnalysisCompletion withReasonCode(RouteAnalysisCompletionReasonCode reasonCode) {
        this.reasonCode = reasonCode.toString();
        return this;
    }

    public Map<String, String> getReasonContext() {
        return this.reasonContext;
    }

    public void setReasonContext(Map<String, String> reasonContext) {
        this.reasonContext = reasonContext;
    }

    public RouteAnalysisCompletion withReasonContext(Map<String, String> reasonContext) {
        this.setReasonContext(reasonContext);
        return this;
    }

    public RouteAnalysisCompletion addReasonContextEntry(String key, String value) {
        if (null == this.reasonContext) {
            this.reasonContext = new HashMap<String, String>();
        }
        if (this.reasonContext.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.reasonContext.put(key, value);
        return this;
    }

    public RouteAnalysisCompletion clearReasonContextEntries() {
        this.reasonContext = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResultCode() != null) {
            sb.append("ResultCode: ").append(this.getResultCode()).append(",");
        }
        if (this.getReasonCode() != null) {
            sb.append("ReasonCode: ").append(this.getReasonCode()).append(",");
        }
        if (this.getReasonContext() != null) {
            sb.append("ReasonContext: ").append(this.getReasonContext());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysisCompletion)) {
            return false;
        }
        RouteAnalysisCompletion other = (RouteAnalysisCompletion)obj;
        if (other.getResultCode() == null ^ this.getResultCode() == null) {
            return false;
        }
        if (other.getResultCode() != null && !other.getResultCode().equals(this.getResultCode())) {
            return false;
        }
        if (other.getReasonCode() == null ^ this.getReasonCode() == null) {
            return false;
        }
        if (other.getReasonCode() != null && !other.getReasonCode().equals(this.getReasonCode())) {
            return false;
        }
        if (other.getReasonContext() == null ^ this.getReasonContext() == null) {
            return false;
        }
        return other.getReasonContext() == null || other.getReasonContext().equals(this.getReasonContext());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResultCode() == null ? 0 : this.getResultCode().hashCode());
        hashCode = 31 * hashCode + (this.getReasonCode() == null ? 0 : this.getReasonCode().hashCode());
        hashCode = 31 * hashCode + (this.getReasonContext() == null ? 0 : this.getReasonContext().hashCode());
        return hashCode;
    }

    public RouteAnalysisCompletion clone() {
        try {
            return (RouteAnalysisCompletion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RouteAnalysisCompletionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

