/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptographydata.model.EncryptionMode;
import com.amazonaws.services.paymentcryptographydata.model.PaddingType;
import com.amazonaws.services.paymentcryptographydata.model.transform.SymmetricEncryptionAttributesMarshaller;
import java.io.Serializable;

public class SymmetricEncryptionAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private String initializationVector;
    private String mode;
    private String paddingType;

    public void setInitializationVector(String initializationVector) {
        this.initializationVector = initializationVector;
    }

    public String getInitializationVector() {
        return this.initializationVector;
    }

    public SymmetricEncryptionAttributes withInitializationVector(String initializationVector) {
        this.setInitializationVector(initializationVector);
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public SymmetricEncryptionAttributes withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public SymmetricEncryptionAttributes withMode(EncryptionMode mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setPaddingType(String paddingType) {
        this.paddingType = paddingType;
    }

    public String getPaddingType() {
        return this.paddingType;
    }

    public SymmetricEncryptionAttributes withPaddingType(String paddingType) {
        this.setPaddingType(paddingType);
        return this;
    }

    public SymmetricEncryptionAttributes withPaddingType(PaddingType paddingType) {
        this.paddingType = paddingType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInitializationVector() != null) {
            sb.append("InitializationVector: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getPaddingType() != null) {
            sb.append("PaddingType: ").append(this.getPaddingType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SymmetricEncryptionAttributes)) {
            return false;
        }
        SymmetricEncryptionAttributes other = (SymmetricEncryptionAttributes)obj;
        if (other.getInitializationVector() == null ^ this.getInitializationVector() == null) {
            return false;
        }
        if (other.getInitializationVector() != null && !other.getInitializationVector().equals(this.getInitializationVector())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getPaddingType() == null ^ this.getPaddingType() == null) {
            return false;
        }
        return other.getPaddingType() == null || other.getPaddingType().equals(this.getPaddingType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInitializationVector() == null ? 0 : this.getInitializationVector().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getPaddingType() == null ? 0 : this.getPaddingType().hashCode());
        return hashCode;
    }

    public SymmetricEncryptionAttributes clone() {
        try {
            return (SymmetricEncryptionAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SymmetricEncryptionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

