/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.proton.model.ComponentSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListComponentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ComponentSummary> components;
    private String nextToken;

    public List<ComponentSummary> getComponents() {
        return this.components;
    }

    public void setComponents(Collection<ComponentSummary> components) {
        if (components == null) {
            this.components = null;
            return;
        }
        this.components = new ArrayList<ComponentSummary>(components);
    }

    public ListComponentsResult withComponents(ComponentSummary ... components) {
        if (this.components == null) {
            this.setComponents(new ArrayList<ComponentSummary>(components.length));
        }
        for (ComponentSummary ele : components) {
            this.components.add(ele);
        }
        return this;
    }

    public ListComponentsResult withComponents(Collection<ComponentSummary> components) {
        this.setComponents(components);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListComponentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponents() != null) {
            sb.append("Components: ").append(this.getComponents()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentsResult)) {
            return false;
        }
        ListComponentsResult other = (ListComponentsResult)obj;
        if (other.getComponents() == null ^ this.getComponents() == null) {
            return false;
        }
        if (other.getComponents() != null && !other.getComponents().equals(this.getComponents())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponents() == null ? 0 : this.getComponents().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListComponentsResult clone() {
        try {
            return (ListComponentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

