/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.TopicIRContributionAnalysis;
import com.amazonaws.services.quicksight.model.TopicIRFilterOption;
import com.amazonaws.services.quicksight.model.TopicIRGroupBy;
import com.amazonaws.services.quicksight.model.TopicIRMetric;
import com.amazonaws.services.quicksight.model.TopicSortClause;
import com.amazonaws.services.quicksight.model.VisualOptions;
import com.amazonaws.services.quicksight.model.transform.TopicIRMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicIR
implements Serializable,
Cloneable,
StructuredPojo {
    private List<TopicIRMetric> metrics;
    private List<TopicIRGroupBy> groupByList;
    private List<List<TopicIRFilterOption>> filters;
    private TopicSortClause sort;
    private TopicIRContributionAnalysis contributionAnalysis;
    private VisualOptions visual;

    public List<TopicIRMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Collection<TopicIRMetric> metrics) {
        if (metrics == null) {
            this.metrics = null;
            return;
        }
        this.metrics = new ArrayList<TopicIRMetric>(metrics);
    }

    public TopicIR withMetrics(TopicIRMetric ... metrics) {
        if (this.metrics == null) {
            this.setMetrics(new ArrayList<TopicIRMetric>(metrics.length));
        }
        for (TopicIRMetric ele : metrics) {
            this.metrics.add(ele);
        }
        return this;
    }

    public TopicIR withMetrics(Collection<TopicIRMetric> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public List<TopicIRGroupBy> getGroupByList() {
        return this.groupByList;
    }

    public void setGroupByList(Collection<TopicIRGroupBy> groupByList) {
        if (groupByList == null) {
            this.groupByList = null;
            return;
        }
        this.groupByList = new ArrayList<TopicIRGroupBy>(groupByList);
    }

    public TopicIR withGroupByList(TopicIRGroupBy ... groupByList) {
        if (this.groupByList == null) {
            this.setGroupByList(new ArrayList<TopicIRGroupBy>(groupByList.length));
        }
        for (TopicIRGroupBy ele : groupByList) {
            this.groupByList.add(ele);
        }
        return this;
    }

    public TopicIR withGroupByList(Collection<TopicIRGroupBy> groupByList) {
        this.setGroupByList(groupByList);
        return this;
    }

    public List<List<TopicIRFilterOption>> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<List<TopicIRFilterOption>> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<List<TopicIRFilterOption>>(filters);
    }

    public TopicIR withFilters(List<TopicIRFilterOption> ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<List<TopicIRFilterOption>>(filters.length));
        }
        for (List<TopicIRFilterOption> ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public TopicIR withFilters(Collection<List<TopicIRFilterOption>> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setSort(TopicSortClause sort) {
        this.sort = sort;
    }

    public TopicSortClause getSort() {
        return this.sort;
    }

    public TopicIR withSort(TopicSortClause sort) {
        this.setSort(sort);
        return this;
    }

    public void setContributionAnalysis(TopicIRContributionAnalysis contributionAnalysis) {
        this.contributionAnalysis = contributionAnalysis;
    }

    public TopicIRContributionAnalysis getContributionAnalysis() {
        return this.contributionAnalysis;
    }

    public TopicIR withContributionAnalysis(TopicIRContributionAnalysis contributionAnalysis) {
        this.setContributionAnalysis(contributionAnalysis);
        return this;
    }

    public void setVisual(VisualOptions visual) {
        this.visual = visual;
    }

    public VisualOptions getVisual() {
        return this.visual;
    }

    public TopicIR withVisual(VisualOptions visual) {
        this.setVisual(visual);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics()).append(",");
        }
        if (this.getGroupByList() != null) {
            sb.append("GroupByList: ").append(this.getGroupByList()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getSort() != null) {
            sb.append("Sort: ").append(this.getSort()).append(",");
        }
        if (this.getContributionAnalysis() != null) {
            sb.append("ContributionAnalysis: ").append(this.getContributionAnalysis()).append(",");
        }
        if (this.getVisual() != null) {
            sb.append("Visual: ").append(this.getVisual());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIR)) {
            return false;
        }
        TopicIR other = (TopicIR)obj;
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getGroupByList() == null ^ this.getGroupByList() == null) {
            return false;
        }
        if (other.getGroupByList() != null && !other.getGroupByList().equals(this.getGroupByList())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getSort() == null ^ this.getSort() == null) {
            return false;
        }
        if (other.getSort() != null && !other.getSort().equals(this.getSort())) {
            return false;
        }
        if (other.getContributionAnalysis() == null ^ this.getContributionAnalysis() == null) {
            return false;
        }
        if (other.getContributionAnalysis() != null && !other.getContributionAnalysis().equals(this.getContributionAnalysis())) {
            return false;
        }
        if (other.getVisual() == null ^ this.getVisual() == null) {
            return false;
        }
        return other.getVisual() == null || other.getVisual().equals(this.getVisual());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getGroupByList() == null ? 0 : this.getGroupByList().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getSort() == null ? 0 : this.getSort().hashCode());
        hashCode = 31 * hashCode + (this.getContributionAnalysis() == null ? 0 : this.getContributionAnalysis().hashCode());
        hashCode = 31 * hashCode + (this.getVisual() == null ? 0 : this.getVisual().hashCode());
        return hashCode;
    }

    public TopicIR clone() {
        try {
            return (TopicIR)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicIRMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

