/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.secretsmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.secretsmanager.model.Filter;
import com.amazonaws.services.secretsmanager.model.SortOrderType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSecretsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Boolean includePlannedDeletion;
    private Integer maxResults;
    private String nextToken;
    private List<Filter> filters;
    private String sortOrder;

    public void setIncludePlannedDeletion(Boolean includePlannedDeletion) {
        this.includePlannedDeletion = includePlannedDeletion;
    }

    public Boolean getIncludePlannedDeletion() {
        return this.includePlannedDeletion;
    }

    public ListSecretsRequest withIncludePlannedDeletion(Boolean includePlannedDeletion) {
        this.setIncludePlannedDeletion(includePlannedDeletion);
        return this;
    }

    public Boolean isIncludePlannedDeletion() {
        return this.includePlannedDeletion;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListSecretsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSecretsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public ListSecretsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ListSecretsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public ListSecretsRequest withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public ListSecretsRequest withSortOrder(SortOrderType sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIncludePlannedDeletion() != null) {
            sb.append("IncludePlannedDeletion: ").append(this.getIncludePlannedDeletion()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: ").append(this.getSortOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecretsRequest)) {
            return false;
        }
        ListSecretsRequest other = (ListSecretsRequest)obj;
        if (other.getIncludePlannedDeletion() == null ^ this.getIncludePlannedDeletion() == null) {
            return false;
        }
        if (other.getIncludePlannedDeletion() != null && !other.getIncludePlannedDeletion().equals(this.getIncludePlannedDeletion())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        return other.getSortOrder() == null || other.getSortOrder().equals(this.getSortOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIncludePlannedDeletion() == null ? 0 : this.getIncludePlannedDeletion().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        return hashCode;
    }

    public ListSecretsRequest clone() {
        return (ListSecretsRequest)super.clone();
    }
}

