/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchSourceMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PatchSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private SdkInternalList<String> products;
    private String configuration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PatchSource withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getProducts() {
        if (this.products == null) {
            this.products = new SdkInternalList();
        }
        return this.products;
    }

    public void setProducts(Collection<String> products) {
        if (products == null) {
            this.products = null;
            return;
        }
        this.products = new SdkInternalList(products);
    }

    public PatchSource withProducts(String ... products) {
        if (this.products == null) {
            this.setProducts((Collection<String>)new SdkInternalList(products.length));
        }
        for (String ele : products) {
            this.products.add((Object)ele);
        }
        return this;
    }

    public PatchSource withProducts(Collection<String> products) {
        this.setProducts(products);
        return this;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public PatchSource withConfiguration(String configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProducts() != null) {
            sb.append("Products: ").append(this.getProducts()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchSource)) {
            return false;
        }
        PatchSource other = (PatchSource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProducts() == null ^ this.getProducts() == null) {
            return false;
        }
        if (other.getProducts() != null && !other.getProducts().equals(this.getProducts())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        return other.getConfiguration() == null || other.getConfiguration().equals(this.getConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProducts() == null ? 0 : this.getProducts().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        return hashCode;
    }

    public PatchSource clone() {
        try {
            return (PatchSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

