/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.ApplicationDiscoveryStatus;
import com.amazonaws.services.ssmsap.model.ApplicationStatus;
import com.amazonaws.services.ssmsap.model.ApplicationType;
import com.amazonaws.services.ssmsap.model.transform.ApplicationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Application
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String type;
    private String arn;
    private String appRegistryArn;
    private String status;
    private String discoveryStatus;
    private List<String> components;
    private Date lastUpdated;
    private String statusMessage;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Application withId(String id) {
        this.setId(id);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Application withType(String type) {
        this.setType(type);
        return this;
    }

    public Application withType(ApplicationType type) {
        this.type = type.toString();
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Application withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setAppRegistryArn(String appRegistryArn) {
        this.appRegistryArn = appRegistryArn;
    }

    public String getAppRegistryArn() {
        return this.appRegistryArn;
    }

    public Application withAppRegistryArn(String appRegistryArn) {
        this.setAppRegistryArn(appRegistryArn);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Application withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Application withStatus(ApplicationStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setDiscoveryStatus(String discoveryStatus) {
        this.discoveryStatus = discoveryStatus;
    }

    public String getDiscoveryStatus() {
        return this.discoveryStatus;
    }

    public Application withDiscoveryStatus(String discoveryStatus) {
        this.setDiscoveryStatus(discoveryStatus);
        return this;
    }

    public Application withDiscoveryStatus(ApplicationDiscoveryStatus discoveryStatus) {
        this.discoveryStatus = discoveryStatus.toString();
        return this;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public void setComponents(Collection<String> components) {
        if (components == null) {
            this.components = null;
            return;
        }
        this.components = new ArrayList<String>(components);
    }

    public Application withComponents(String ... components) {
        if (this.components == null) {
            this.setComponents(new ArrayList<String>(components.length));
        }
        for (String ele : components) {
            this.components.add(ele);
        }
        return this;
    }

    public Application withComponents(Collection<String> components) {
        this.setComponents(components);
        return this;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public Application withLastUpdated(Date lastUpdated) {
        this.setLastUpdated(lastUpdated);
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Application withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAppRegistryArn() != null) {
            sb.append("AppRegistryArn: ").append(this.getAppRegistryArn()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getDiscoveryStatus() != null) {
            sb.append("DiscoveryStatus: ").append(this.getDiscoveryStatus()).append(",");
        }
        if (this.getComponents() != null) {
            sb.append("Components: ").append(this.getComponents()).append(",");
        }
        if (this.getLastUpdated() != null) {
            sb.append("LastUpdated: ").append(this.getLastUpdated()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAppRegistryArn() == null ^ this.getAppRegistryArn() == null) {
            return false;
        }
        if (other.getAppRegistryArn() != null && !other.getAppRegistryArn().equals(this.getAppRegistryArn())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDiscoveryStatus() == null ^ this.getDiscoveryStatus() == null) {
            return false;
        }
        if (other.getDiscoveryStatus() != null && !other.getDiscoveryStatus().equals(this.getDiscoveryStatus())) {
            return false;
        }
        if (other.getComponents() == null ^ this.getComponents() == null) {
            return false;
        }
        if (other.getComponents() != null && !other.getComponents().equals(this.getComponents())) {
            return false;
        }
        if (other.getLastUpdated() == null ^ this.getLastUpdated() == null) {
            return false;
        }
        if (other.getLastUpdated() != null && !other.getLastUpdated().equals(this.getLastUpdated())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        return other.getStatusMessage() == null || other.getStatusMessage().equals(this.getStatusMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAppRegistryArn() == null ? 0 : this.getAppRegistryArn().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDiscoveryStatus() == null ? 0 : this.getDiscoveryStatus().hashCode());
        hashCode = 31 * hashCode + (this.getComponents() == null ? 0 : this.getComponents().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdated() == null ? 0 : this.getLastUpdated().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        return hashCode;
    }

    public Application clone() {
        try {
            return (Application)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

