/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.Component;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ComponentMarshaller {
    private static final MarshallingInfo<String> COMPONENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComponentId").build();
    private static final MarshallingInfo<String> PARENTCOMPONENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentComponent").build();
    private static final MarshallingInfo<List> CHILDCOMPONENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChildComponents").build();
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").build();
    private static final MarshallingInfo<String> COMPONENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComponentType").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> SAPHOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SapHostname").build();
    private static final MarshallingInfo<String> SAPKERNELVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SapKernelVersion").build();
    private static final MarshallingInfo<String> HDBVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HdbVersion").build();
    private static final MarshallingInfo<StructuredPojo> RESILIENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resilience").build();
    private static final MarshallingInfo<StructuredPojo> ASSOCIATEDHOST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociatedHost").build();
    private static final MarshallingInfo<List> DATABASES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Databases").build();
    private static final MarshallingInfo<List> HOSTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hosts").build();
    private static final MarshallingInfo<String> PRIMARYHOST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrimaryHost").build();
    private static final MarshallingInfo<Date> LASTUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final ComponentMarshaller instance = new ComponentMarshaller();

    public static ComponentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Component component, ProtocolMarshaller protocolMarshaller) {
        if (component == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)component.getComponentId(), COMPONENTID_BINDING);
            protocolMarshaller.marshall((Object)component.getParentComponent(), PARENTCOMPONENT_BINDING);
            protocolMarshaller.marshall(component.getChildComponents(), CHILDCOMPONENTS_BINDING);
            protocolMarshaller.marshall((Object)component.getApplicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)component.getComponentType(), COMPONENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)component.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)component.getSapHostname(), SAPHOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)component.getSapKernelVersion(), SAPKERNELVERSION_BINDING);
            protocolMarshaller.marshall((Object)component.getHdbVersion(), HDBVERSION_BINDING);
            protocolMarshaller.marshall((Object)component.getResilience(), RESILIENCE_BINDING);
            protocolMarshaller.marshall((Object)component.getAssociatedHost(), ASSOCIATEDHOST_BINDING);
            protocolMarshaller.marshall(component.getDatabases(), DATABASES_BINDING);
            protocolMarshaller.marshall(component.getHosts(), HOSTS_BINDING);
            protocolMarshaller.marshall((Object)component.getPrimaryHost(), PRIMARYHOST_BINDING);
            protocolMarshaller.marshall((Object)component.getLastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall((Object)component.getArn(), ARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

