/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.stepfunctions.model.ListExecutionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListExecutionsRequestMarshaller
implements Marshaller<Request<ListExecutionsRequest>, ListExecutionsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListExecutionsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListExecutionsRequest> marshall(ListExecutionsRequest listExecutionsRequest) {
        if (listExecutionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listExecutionsRequest, "AWSStepFunctions");
        request.addHeader("X-Amz-Target", "AWSStepFunctions.ListExecutions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listExecutionsRequest.getStateMachineArn() != null) {
                jsonGenerator.writeFieldName("stateMachineArn").writeValue(listExecutionsRequest.getStateMachineArn());
            }
            if (listExecutionsRequest.getStatusFilter() != null) {
                jsonGenerator.writeFieldName("statusFilter").writeValue(listExecutionsRequest.getStatusFilter());
            }
            if (listExecutionsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listExecutionsRequest.getMaxResults().intValue());
            }
            if (listExecutionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listExecutionsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

