/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transcribe.model.SubtitleFormat;
import com.amazonaws.services.transcribe.model.transform.SubtitlesOutputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SubtitlesOutput
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> formats;
    private List<String> subtitleFileUris;
    private Integer outputStartIndex;

    public List<String> getFormats() {
        return this.formats;
    }

    public void setFormats(Collection<String> formats) {
        if (formats == null) {
            this.formats = null;
            return;
        }
        this.formats = new ArrayList<String>(formats);
    }

    public SubtitlesOutput withFormats(String ... formats) {
        if (this.formats == null) {
            this.setFormats(new ArrayList<String>(formats.length));
        }
        for (String ele : formats) {
            this.formats.add(ele);
        }
        return this;
    }

    public SubtitlesOutput withFormats(Collection<String> formats) {
        this.setFormats(formats);
        return this;
    }

    public SubtitlesOutput withFormats(SubtitleFormat ... formats) {
        ArrayList<String> formatsCopy = new ArrayList<String>(formats.length);
        for (SubtitleFormat value : formats) {
            formatsCopy.add(value.toString());
        }
        if (this.getFormats() == null) {
            this.setFormats(formatsCopy);
        } else {
            this.getFormats().addAll(formatsCopy);
        }
        return this;
    }

    public List<String> getSubtitleFileUris() {
        return this.subtitleFileUris;
    }

    public void setSubtitleFileUris(Collection<String> subtitleFileUris) {
        if (subtitleFileUris == null) {
            this.subtitleFileUris = null;
            return;
        }
        this.subtitleFileUris = new ArrayList<String>(subtitleFileUris);
    }

    public SubtitlesOutput withSubtitleFileUris(String ... subtitleFileUris) {
        if (this.subtitleFileUris == null) {
            this.setSubtitleFileUris(new ArrayList<String>(subtitleFileUris.length));
        }
        for (String ele : subtitleFileUris) {
            this.subtitleFileUris.add(ele);
        }
        return this;
    }

    public SubtitlesOutput withSubtitleFileUris(Collection<String> subtitleFileUris) {
        this.setSubtitleFileUris(subtitleFileUris);
        return this;
    }

    public void setOutputStartIndex(Integer outputStartIndex) {
        this.outputStartIndex = outputStartIndex;
    }

    public Integer getOutputStartIndex() {
        return this.outputStartIndex;
    }

    public SubtitlesOutput withOutputStartIndex(Integer outputStartIndex) {
        this.setOutputStartIndex(outputStartIndex);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormats() != null) {
            sb.append("Formats: ").append(this.getFormats()).append(",");
        }
        if (this.getSubtitleFileUris() != null) {
            sb.append("SubtitleFileUris: ").append(this.getSubtitleFileUris()).append(",");
        }
        if (this.getOutputStartIndex() != null) {
            sb.append("OutputStartIndex: ").append(this.getOutputStartIndex());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubtitlesOutput)) {
            return false;
        }
        SubtitlesOutput other = (SubtitlesOutput)obj;
        if (other.getFormats() == null ^ this.getFormats() == null) {
            return false;
        }
        if (other.getFormats() != null && !other.getFormats().equals(this.getFormats())) {
            return false;
        }
        if (other.getSubtitleFileUris() == null ^ this.getSubtitleFileUris() == null) {
            return false;
        }
        if (other.getSubtitleFileUris() != null && !other.getSubtitleFileUris().equals(this.getSubtitleFileUris())) {
            return false;
        }
        if (other.getOutputStartIndex() == null ^ this.getOutputStartIndex() == null) {
            return false;
        }
        return other.getOutputStartIndex() == null || other.getOutputStartIndex().equals(this.getOutputStartIndex());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormats() == null ? 0 : this.getFormats().hashCode());
        hashCode = 31 * hashCode + (this.getSubtitleFileUris() == null ? 0 : this.getSubtitleFileUris().hashCode());
        hashCode = 31 * hashCode + (this.getOutputStartIndex() == null ? 0 : this.getOutputStartIndex().hashCode());
        return hashCode;
    }

    public SubtitlesOutput clone() {
        try {
            return (SubtitlesOutput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubtitlesOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

