/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.InputFileLocation;

@SdkInternalApi
public class InputFileLocationMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3FILELOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3FileLocation").build();
    private static final MarshallingInfo<StructuredPojo> EFSFILELOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EfsFileLocation").build();
    private static final InputFileLocationMarshaller instance = new InputFileLocationMarshaller();

    public static InputFileLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputFileLocation inputFileLocation, ProtocolMarshaller protocolMarshaller) {
        if (inputFileLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputFileLocation.getS3FileLocation(), S3FILELOCATION_BINDING);
            protocolMarshaller.marshall((Object)inputFileLocation.getEfsFileLocation(), EFSFILELOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

