/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.ErrorStatistics;

public class ErrorStatisticsJsonMarshaller {
    private static ErrorStatisticsJsonMarshaller instance;

    public void marshall(ErrorStatistics errorStatistics, StructuredJsonGenerator jsonGenerator) {
        if (errorStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (errorStatistics.getThrottleCount() != null) {
                jsonGenerator.writeFieldName("ThrottleCount").writeValue(errorStatistics.getThrottleCount().longValue());
            }
            if (errorStatistics.getOtherCount() != null) {
                jsonGenerator.writeFieldName("OtherCount").writeValue(errorStatistics.getOtherCount().longValue());
            }
            if (errorStatistics.getTotalCount() != null) {
                jsonGenerator.writeFieldName("TotalCount").writeValue(errorStatistics.getTotalCount().longValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ErrorStatisticsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ErrorStatisticsJsonMarshaller();
        }
        return instance;
    }
}

