/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.PutTelemetryRecordsRequest;
import com.amazonaws.services.xray.model.TelemetryRecord;
import com.amazonaws.services.xray.model.transform.TelemetryRecordJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class PutTelemetryRecordsRequestMarshaller
implements Marshaller<Request<PutTelemetryRecordsRequest>, PutTelemetryRecordsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutTelemetryRecordsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutTelemetryRecordsRequest> marshall(PutTelemetryRecordsRequest putTelemetryRecordsRequest) {
        if (putTelemetryRecordsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putTelemetryRecordsRequest, "AWSXRay");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/TelemetryRecords";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<TelemetryRecord> telemetryRecordsList = putTelemetryRecordsRequest.getTelemetryRecords();
            if (telemetryRecordsList != null) {
                jsonGenerator.writeFieldName("TelemetryRecords");
                jsonGenerator.writeStartArray();
                for (TelemetryRecord telemetryRecordsListValue : telemetryRecordsList) {
                    if (telemetryRecordsListValue == null) continue;
                    TelemetryRecordJsonMarshaller.getInstance().marshall(telemetryRecordsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (putTelemetryRecordsRequest.getEC2InstanceId() != null) {
                jsonGenerator.writeFieldName("EC2InstanceId").writeValue(putTelemetryRecordsRequest.getEC2InstanceId());
            }
            if (putTelemetryRecordsRequest.getHostname() != null) {
                jsonGenerator.writeFieldName("Hostname").writeValue(putTelemetryRecordsRequest.getHostname());
            }
            if (putTelemetryRecordsRequest.getResourceARN() != null) {
                jsonGenerator.writeFieldName("ResourceARN").writeValue(putTelemetryRecordsRequest.getResourceARN());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

