/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import java.util.Optional;

public class CreateDynamoDBTableOptions {
    private final AmazonDynamoDB dynamoDBClient;
    private final ProvisionedThroughput provisionedThroughput;
    private final String tableName;
    private final String partitionKeyName;
    private final Optional<String> sortKeyName;
    private final Optional<RequestMetricCollector> requestMetricCollector;

    CreateDynamoDBTableOptions(AmazonDynamoDB dynamoDBClient, ProvisionedThroughput provisionedThroughput, String tableName, String partitionKeyName, Optional<String> sortKeyName, Optional<RequestMetricCollector> requestMetricCollector) {
        this.dynamoDBClient = dynamoDBClient;
        this.provisionedThroughput = provisionedThroughput;
        this.tableName = tableName;
        this.partitionKeyName = partitionKeyName;
        this.sortKeyName = sortKeyName;
        this.requestMetricCollector = requestMetricCollector;
    }

    public static CreateDynamoDBTableOptionsBuilder builder(AmazonDynamoDB dynamoDBClient, ProvisionedThroughput provisionedThroughput, String tableName) {
        return new CreateDynamoDBTableOptionsBuilder(dynamoDBClient, provisionedThroughput, tableName);
    }

    AmazonDynamoDB getDynamoDBClient() {
        return this.dynamoDBClient;
    }

    ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    String getTableName() {
        return this.tableName;
    }

    String getPartitionKeyName() {
        return this.partitionKeyName;
    }

    Optional<String> getSortKeyName() {
        return this.sortKeyName;
    }

    Optional<RequestMetricCollector> getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public static class CreateDynamoDBTableOptionsBuilder {
        private AmazonDynamoDB dynamoDBClient;
        private ProvisionedThroughput provisionedThroughput;
        private String tableName;
        private String partitionKeyName;
        private Optional<String> sortKeyName;
        private Optional<RequestMetricCollector> requestMetricCollector;

        CreateDynamoDBTableOptionsBuilder(AmazonDynamoDB dynamoDBClient, ProvisionedThroughput provisionedThroughput, String tableName) {
            this.dynamoDBClient = dynamoDBClient;
            this.provisionedThroughput = provisionedThroughput;
            this.tableName = tableName;
            this.partitionKeyName = "key";
            this.sortKeyName = Optional.empty();
            this.requestMetricCollector = Optional.empty();
        }

        public CreateDynamoDBTableOptionsBuilder withPartitionKeyName(String partitionKeyName) {
            this.partitionKeyName = partitionKeyName;
            return this;
        }

        public CreateDynamoDBTableOptionsBuilder withSortKeyName(String sortKeyName) {
            this.sortKeyName = Optional.ofNullable(sortKeyName);
            return this;
        }

        public CreateDynamoDBTableOptionsBuilder withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
            this.requestMetricCollector = Optional.ofNullable(requestMetricCollector);
            return this;
        }

        public CreateDynamoDBTableOptions build() {
            return new CreateDynamoDBTableOptions(this.dynamoDBClient, this.provisionedThroughput, this.tableName, this.partitionKeyName, this.sortKeyName, this.requestMetricCollector);
        }

        public String toString() {
            return "CreateDynamoDBTableOptions.CreateDynamoDBTableOptionsBuilder(dynamoDBClient=" + this.dynamoDBClient + ", provisionedThroughput=" + this.provisionedThroughput + ", tableName=" + this.tableName + ", partitionKeyName=" + this.partitionKeyName + ", sortKeyName=" + this.sortKeyName + ", requestMetricCollector=" + this.requestMetricCollector + ")";
        }
    }
}

