/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.utils;

import com.anji.plus.gaea.annotation.DtoSkip;
import com.anji.plus.gaea.annotation.Formatter;
import com.anji.plus.gaea.annotation.FormatterType;
import com.anji.plus.gaea.cache.CacheHelper;
import com.anji.plus.gaea.constant.Enabled;
import com.anji.plus.gaea.holder.UserContentHolder;
import com.anji.plus.gaea.utils.ApplicationContextUtils;
import com.anji.plus.gaea.utils.GaeaUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class GaeaBeanUtils {
    private static final Logger logger = LoggerFactory.getLogger(GaeaBeanUtils.class);

    public static <T> T copyAndFormatter(Object source, T target) {
        Field[] declaredFields = target.getClass().getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(declaredFields.length);
        ArrayList<String> skipFields = new ArrayList<String>();
        ArrayList<Field> formatterTypeFields = new ArrayList<Field>();
        for (Field field : declaredFields) {
            if (field.isAnnotationPresent(DtoSkip.class)) {
                skipFields.add(field.getName());
                continue;
            }
            if (field.isAnnotationPresent(FormatterType.class)) {
                formatterTypeFields.add(field);
                continue;
            }
            fields.add(field);
        }
        skipFields.addAll(formatterTypeFields.stream().map(Field::getName).collect(Collectors.toList()));
        BeanUtils.copyProperties((Object)source, target, (String[])skipFields.toArray(new String[0]));
        Field[] superDeclaredFields = target.getClass().getSuperclass().getDeclaredFields();
        fields.addAll(Arrays.asList(superDeclaredFields));
        GaeaBeanUtils.formatterHandler(source, target, fields);
        for (Field field : formatterTypeFields) {
            try {
                PropertyDescriptor sourcePropertyDescriptor = new PropertyDescriptor(field.getName(), source.getClass());
                PropertyDescriptor targetPropertyDescriptor = new PropertyDescriptor(field.getName(), target.getClass());
                Object fieldSource = sourcePropertyDescriptor.getReadMethod().invoke(source, new Object[0]);
                if (fieldSource == null) continue;
                Method writeMethod = targetPropertyDescriptor.getWriteMethod();
                switch (field.getAnnotation(FormatterType.class).type()) {
                    case OBJECT: {
                        Object fieldTarget = field.getType().newInstance();
                        GaeaBeanUtils.copyAndFormatter(fieldSource, fieldTarget);
                        writeMethod.invoke(target, fieldTarget);
                        break;
                    }
                    case LIST: {
                        Type genericType = field.getGenericType();
                        ParameterizedType parameterizedType = (ParameterizedType)genericType;
                        Class fieldTargetClass = (Class)parameterizedType.getActualTypeArguments()[0];
                        List<T> fieldTargetList = GaeaBeanUtils.copyList((List)fieldSource, fieldTargetClass);
                        writeMethod.invoke(target, fieldTargetList);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.error("FormatterType\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
        }
        return target;
    }

    public static <T> List<T> copyList(List<? extends Object> sourceList, Class<T> targetClass) {
        return sourceList.stream().map(source -> {
            try {
                Object target = targetClass.newInstance();
                GaeaBeanUtils.copyAndFormatter(source, target);
                return target;
            }
            catch (Exception e) {
                logger.error("\u96c6\u5408\u7ffb\u8bd1\u5931\u8d25,\u76ee\u6807\u7c7b\uff1a" + targetClass.getName(), (Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
    }

    private static <T> void formatterHandler(Object source, T target, List<Field> fields) {
        Locale locale = LocaleContextHolder.getLocale();
        String language = locale.getLanguage();
        Map<String, Object> params = UserContentHolder.getContext().getParams();
        ((Stream)fields.stream().parallel()).filter(field -> field.isAnnotationPresent(Formatter.class)).forEach(field -> {
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), target.getClass());
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(target, new Object[0]);
                if (result instanceof Boolean) {
                    Object object = result = (Boolean)result != false ? Enabled.YES.getValue() : Enabled.NO.getValue();
                }
                if (result != null) {
                    String key;
                    Formatter annotation = field.getAnnotation(Formatter.class);
                    CacheHelper cacheHelper = ApplicationContextUtils.getBean(CacheHelper.class);
                    if (StringUtils.isBlank((CharSequence)annotation.key())) {
                        String dictCode = annotation.dictCode();
                        key = "gaea:dict:prefix:" + language + ":" + dictCode;
                    } else {
                        key = GaeaBeanUtils.formatKey(annotation.key(), annotation.replace(), params, source);
                    }
                    String hashKey = result.toString();
                    String dictValue = cacheHelper.hashGetString(key, hashKey);
                    if (StringUtils.isBlank((CharSequence)dictValue)) {
                        dictValue = cacheHelper.hashGetString(key, hashKey.toLowerCase());
                    }
                    if (StringUtils.isNotBlank((CharSequence)dictValue)) {
                        PropertyDescriptor descriptorTarget = new PropertyDescriptor(field.getName(), target.getClass());
                        if (StringUtils.isBlank((CharSequence)annotation.targetField())) {
                            Method writeMethod = descriptorTarget.getWriteMethod();
                            writeMethod.invoke(target, dictValue);
                        } else {
                            descriptorTarget = new PropertyDescriptor(annotation.targetField(), target.getClass());
                            if (descriptorTarget != null) {
                                descriptorTarget.getWriteMethod().invoke(target, dictValue);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static String formatKey(String key, String[] replaceArray, Map<String, Object> params, Object source) {
        if (key.contains("${")) {
            HashMap<String, Object> keyPatternMap = new HashMap<String, Object>(2);
            for (String fieldName : replaceArray) {
                try {
                    Object value = params.get(fieldName);
                    if (null == value) {
                        Field declaredField = source.getClass().getDeclaredField(fieldName);
                        declaredField.setAccessible(true);
                        value = declaredField.get(source);
                    }
                    keyPatternMap.put(fieldName, value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((key = GaeaUtils.replaceFormatString(key, keyPatternMap)).contains("${")) {
                return null;
            }
        }
        return key;
    }
}

