/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpRequest;
import com.azure.core.test.http.AssertingClient;
import com.azure.core.util.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class AssertingHttpClientBuilder {
    private final HttpClient delegate;
    private final List<Predicate<HttpRequest>> syncAssertions;
    private final List<Predicate<HttpRequest>> asyncAssertions;
    private BiFunction<HttpRequest, Context, Boolean> biFunction;

    public AssertingHttpClientBuilder(HttpClient delegate) {
        this.delegate = delegate;
        this.syncAssertions = new ArrayList<Predicate<HttpRequest>>();
        this.asyncAssertions = new ArrayList<Predicate<HttpRequest>>();
    }

    public AssertingHttpClientBuilder assertSync() {
        this.asyncAssertions.add(request -> false);
        return this;
    }

    public AssertingHttpClientBuilder assertAsync() {
        this.syncAssertions.add(request -> false);
        return this;
    }

    public HttpClient build() {
        return new AssertingClient(this.delegate, this.syncAssertions, this.asyncAssertions, this.biFunction);
    }

    public AssertingHttpClientBuilder skipRequest(BiFunction<HttpRequest, Context, Boolean> skipRequestFunction) {
        this.biFunction = skipRequestFunction;
        return this;
    }
}

