/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils.metrics;

import com.azure.core.test.utils.metrics.TestMeasurement;
import com.azure.core.test.utils.metrics.TestTelemetryAttributes;
import com.azure.core.util.Context;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.metrics.DoubleHistogram;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public class TestHistogram
implements DoubleHistogram {
    private final ConcurrentLinkedQueue<TestMeasurement<Double>> measurements = new ConcurrentLinkedQueue();
    private final boolean isEnabled;

    TestHistogram(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void record(double value, TelemetryAttributes attributes, Context context) {
        if (this.isEnabled) {
            this.measurements.add(new TestMeasurement<Double>(value, (TestTelemetryAttributes)attributes, context));
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public List<TestMeasurement<Double>> getMeasurements() {
        return this.measurements.stream().collect(Collectors.toList());
    }
}

