/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpHeaders
implements Iterable<HttpHeader> {
    private final Map<String, HttpHeader> headers = new ConcurrentHashMap<String, HttpHeader>();

    public HttpHeaders() {
    }

    public HttpHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            this.put(header.getKey(), header.getValue());
        }
    }

    public HttpHeaders(Iterable<HttpHeader> headers) {
        this();
        for (HttpHeader header : headers) {
            this.put(header.getName(), header.getValue());
        }
    }

    public int getSize() {
        return this.headers.size();
    }

    public HttpHeaders put(String name, String value) {
        this.headers.put(this.formatKey(name), new HttpHeader(name, value));
        return this;
    }

    public HttpHeader get(String name) {
        return this.headers.get(this.formatKey(name));
    }

    public HttpHeader remove(String name) {
        return this.headers.remove(this.formatKey(name));
    }

    public String getValue(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValue();
    }

    public String[] getValues(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValues();
    }

    private String formatKey(String key) {
        return key.toLowerCase(Locale.ROOT);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (HttpHeader header : this.headers.values()) {
            result.put(header.getName(), header.getValue());
        }
        return result;
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return this.headers.values().iterator();
    }

    public Stream<HttpHeader> stream() {
        return this.headers.values().stream();
    }

    public String toString() {
        return this.stream().map(header -> header.getName() + "=" + header.getValue()).collect(Collectors.joining(", "));
    }
}

