/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class ProxyOptions {
    private static final ClientLogger LOGGER = new ClientLogger(ProxyOptions.class);
    private static final String INVALID_CONFIGURATION_MESSAGE = "'configuration' cannot be 'Configuration.NONE'.";
    private static final String INVALID_AZURE_PROXY_URL = "Configuration {} is an invalid URL and is being ignored.";
    private static final String JAVA_PROXY_PREREQUISITE = "java.net.useSystemProxies";
    private static final String JAVA_PROXY_HOST = "proxyHost";
    private static final String JAVA_PROXY_PORT = "proxyPort";
    private static final String JAVA_PROXY_USER = "proxyUser";
    private static final String JAVA_PROXY_PASSWORD = "proxyPassword";
    private static final String JAVA_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTPS = "https";
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String HTTP = "http";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final List<Function<Configuration, ProxyOptions>> ENVIRONMENT_LOAD_ORDER = Arrays.asList(configuration -> ProxyOptions.attemptToLoadAzureProxy(configuration, "HTTPS_PROXY"), configuration -> ProxyOptions.attemptToLoadAzureProxy(configuration, "HTTP_PROXY"), configuration -> ProxyOptions.attemptToLoadJavaProxy(configuration, HTTPS), configuration -> ProxyOptions.attemptToLoadJavaProxy(configuration, HTTP));
    private final InetSocketAddress address;
    private final Type type;
    private String username;
    private String password;
    private String nonProxyHosts;

    public ProxyOptions(Type type, InetSocketAddress address) {
        this.type = type;
        this.address = address;
    }

    public ProxyOptions setCredentials(String username, String password) {
        this.username = Objects.requireNonNull(username, "'username' cannot be null.");
        this.password = Objects.requireNonNull(password, "'password' cannot be null.");
        return this;
    }

    public ProxyOptions setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
        return this;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public Type getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public static ProxyOptions fromConfiguration(Configuration configuration) {
        if (configuration == Configuration.NONE) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException(INVALID_CONFIGURATION_MESSAGE));
        }
        Configuration proxyConfiguration = configuration == null ? Configuration.getGlobalConfiguration() : configuration;
        for (Function<Configuration, ProxyOptions> loader : ENVIRONMENT_LOAD_ORDER) {
            ProxyOptions proxyOptions = loader.apply(proxyConfiguration);
            if (proxyOptions == null) continue;
            return proxyOptions;
        }
        return null;
    }

    private static ProxyOptions attemptToLoadAzureProxy(Configuration configuration, String proxyProperty) {
        String proxyConfiguration = configuration.get(proxyProperty);
        if (CoreUtils.isNullOrEmpty(proxyConfiguration)) {
            return null;
        }
        try {
            String[] usernamePassword;
            URL proxyUrl = new URL(proxyConfiguration);
            int port = proxyUrl.getPort() == -1 ? proxyUrl.getDefaultPort() : proxyUrl.getPort();
            ProxyOptions proxyOptions = new ProxyOptions(Type.HTTP, new InetSocketAddress(proxyUrl.getHost(), port)).setNonProxyHosts(configuration.get("NO_PROXY"));
            String userInfo = proxyUrl.getUserInfo();
            if (userInfo != null && (usernamePassword = userInfo.split(":", 2)).length == 2) {
                try {
                    proxyOptions.setCredentials(URLDecoder.decode(usernamePassword[0], StandardCharsets.UTF_8.toString()), URLDecoder.decode(usernamePassword[1], StandardCharsets.UTF_8.toString()));
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
            return proxyOptions;
        }
        catch (MalformedURLException ex) {
            LOGGER.warning(INVALID_AZURE_PROXY_URL, proxyProperty);
            return null;
        }
    }

    private static ProxyOptions attemptToLoadJavaProxy(Configuration configuration, String type) {
        int port;
        if (!Boolean.parseBoolean(configuration.get(JAVA_PROXY_PREREQUISITE))) {
            return null;
        }
        String host = configuration.get(type + "." + JAVA_PROXY_HOST);
        if (CoreUtils.isNullOrEmpty(host)) {
            return null;
        }
        try {
            port = Integer.parseInt(configuration.get(type + "." + JAVA_PROXY_PORT));
        }
        catch (NumberFormatException ex) {
            port = HTTPS.equals(type) ? 443 : 80;
        }
        ProxyOptions proxyOptions = new ProxyOptions(Type.HTTP, new InetSocketAddress(host, port)).setNonProxyHosts(configuration.get(JAVA_NON_PROXY_HOSTS));
        String username = configuration.get(type + "." + JAVA_PROXY_USER);
        String password = configuration.get(type + "." + JAVA_PROXY_PASSWORD);
        if (username != null && password != null) {
            proxyOptions.setCredentials(username, password);
        }
        return proxyOptions;
    }

    public static enum Type {
        HTTP(Proxy.Type.HTTP),
        SOCKS4(Proxy.Type.SOCKS),
        SOCKS5(Proxy.Type.SOCKS);

        private final Proxy.Type proxyType;

        private Type(Proxy.Type proxyType) {
            this.proxyType = proxyType;
        }

        public Proxy.Type toProxyType() {
            return this.proxyType;
        }
    }
}

