/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.HashSet;
import java.util.Set;

final class PercentEscaper {
    private static final char[] HEX_CHARACTERS = "0123456789ABCDEF".toCharArray();
    private static final String SAFE_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private final ClientLogger logger = new ClientLogger(PercentEscaper.class);
    private final boolean usePlusForSpace;
    private final Set<Integer> safeCharacterPoints;

    PercentEscaper(String safeCharacters, boolean usePlusForSpace) {
        this.usePlusForSpace = usePlusForSpace;
        if (usePlusForSpace && safeCharacters != null && safeCharacters.contains(" ")) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("' ' as a safe character with 'usePlusForSpace = true' is an invalid configuration."));
        }
        this.safeCharacterPoints = new HashSet<Integer>();
        SAFE_CHARACTERS.codePoints().forEach(this.safeCharacterPoints::add);
        if (!CoreUtils.isNullOrEmpty(safeCharacters)) {
            safeCharacters.codePoints().forEach(this.safeCharacterPoints::add);
        }
    }

    public String escape(String original) {
        int codePoint;
        if (CoreUtils.isNullOrEmpty(original)) {
            return original;
        }
        StringBuilder escapedBuilder = new StringBuilder();
        int end = original.length();
        for (int index = 0; index < end; index += Character.isSupplementaryCodePoint(codePoint = PercentEscaper.getCodePoint(original, index, end, this.logger)) ? 2 : 1) {
            char[] chars;
            if (this.safeCharacterPoints.contains(codePoint)) {
                escapedBuilder.append(Character.toChars(codePoint));
                continue;
            }
            if (this.usePlusForSpace && codePoint == 32) {
                escapedBuilder.append('+');
                continue;
            }
            if (codePoint <= 127) {
                escapedBuilder.append('%');
                escapedBuilder.append(HEX_CHARACTERS[codePoint >>> 4]);
                escapedBuilder.append(HEX_CHARACTERS[codePoint & 0xF]);
                continue;
            }
            if (codePoint <= 2047) {
                chars = new char[6];
                chars[0] = 37;
                chars[3] = 37;
                chars[5] = HEX_CHARACTERS[codePoint & 0xF];
                chars[4] = HEX_CHARACTERS[8 | (codePoint >>>= 4) & 3];
                chars[2] = HEX_CHARACTERS[(codePoint >>>= 2) & 0xF];
                chars[1] = HEX_CHARACTERS[(codePoint >>>= 4) | 0xC];
                escapedBuilder.append(chars);
                continue;
            }
            if (codePoint > 65535) continue;
            chars = new char[9];
            chars[0] = 37;
            chars[1] = 69;
            chars[3] = 37;
            chars[6] = 37;
            chars[8] = HEX_CHARACTERS[codePoint & 0xF];
            chars[7] = HEX_CHARACTERS[8 | (codePoint >>>= 4) & 3];
            chars[5] = HEX_CHARACTERS[(codePoint >>>= 2) & 0xF];
            chars[4] = HEX_CHARACTERS[8 | (codePoint >>>= 4) & 3];
            chars[2] = HEX_CHARACTERS[(codePoint >>>= 2) & 0xF];
            escapedBuilder.append(chars);
        }
        return escapedBuilder.toString();
    }

    private static int getCodePoint(String original, int index, int end, ClientLogger logger) {
        char char1;
        if (!Character.isSurrogate(char1 = original.charAt(index++))) {
            return char1;
        }
        if (Character.isHighSurrogate(char1)) {
            if (index == end) {
                throw logger.logExceptionAsError(new IllegalStateException("String contains trailing high surrogate without paired low surrogate."));
            }
            char char2 = original.charAt(index);
            if (Character.isLowSurrogate(char2)) {
                return Character.toCodePoint(char1, char2);
            }
            throw logger.logExceptionAsError(new IllegalStateException("String contains high surrogate without trailing low surrogate."));
        }
        throw logger.logExceptionAsError(new IllegalStateException("String contains low surrogate without leading high surrogate."));
    }
}

