/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.HnswParameters;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmConfiguration;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmKind;
import java.io.IOException;

public final class HnswAlgorithmConfiguration
extends VectorSearchAlgorithmConfiguration {
    private VectorSearchAlgorithmKind kind = VectorSearchAlgorithmKind.HNSW;
    private HnswParameters parameters;

    public HnswAlgorithmConfiguration(String name) {
        super(name);
    }

    @Override
    public VectorSearchAlgorithmKind getKind() {
        return this.kind;
    }

    public HnswParameters getParameters() {
        return this.parameters;
    }

    public HnswAlgorithmConfiguration setParameters(HnswParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("hnswParameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static HnswAlgorithmConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (HnswAlgorithmConfiguration)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            VectorSearchAlgorithmKind kind = VectorSearchAlgorithmKind.HNSW;
            HnswParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchAlgorithmKind.fromString(reader.getString());
                    continue;
                }
                if ("hnswParameters".equals(fieldName)) {
                    parameters = HnswParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                HnswAlgorithmConfiguration deserializedHnswAlgorithmConfiguration = new HnswAlgorithmConfiguration(name);
                deserializedHnswAlgorithmConfiguration.kind = kind;
                deserializedHnswAlgorithmConfiguration.parameters = parameters;
                return deserializedHnswAlgorithmConfiguration;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

