/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CharFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MappingCharFilter
extends CharFilter {
    private String odataType = "#Microsoft.Azure.Search.MappingCharFilter";
    private final List<String> mappings;

    public MappingCharFilter(String name, List<String> mappings) {
        super(name);
        this.mappings = mappings;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public List<String> getMappings() {
        return this.mappings;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("mappings", this.mappings, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static MappingCharFilter fromJson(JsonReader jsonReader) throws IOException {
        return (MappingCharFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean mappingsFound = false;
            List mappings = null;
            String odataType = "#Microsoft.Azure.Search.MappingCharFilter";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("mappings".equals(fieldName)) {
                    mappings = reader.readArray(reader1 -> reader1.getString());
                    mappingsFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && mappingsFound) {
                MappingCharFilter deserializedMappingCharFilter = new MappingCharFilter(name, mappings);
                deserializedMappingCharFilter.odataType = odataType;
                return deserializedMappingCharFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!mappingsFound) {
                missingProperties.add("mappings");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

