/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import com.azure.search.documents.indexes.models.RegexFlags;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class PatternTokenizer
extends LexicalTokenizer {
    private String odataType = "#Microsoft.Azure.Search.PatternTokenizer";
    private String pattern;
    private RegexFlags flags;
    private Integer group;

    public PatternTokenizer(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getPattern() {
        return this.pattern;
    }

    public PatternTokenizer setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public List<RegexFlags> getFlags() {
        if (this.flags == null) {
            return null;
        }
        String[] flagStrings = this.flags.toString().split("\\|");
        return Arrays.stream(flagStrings).map(RegexFlags::fromString).collect(Collectors.toList());
    }

    public PatternTokenizer setFlags(List<RegexFlags> flags) {
        if (flags == null) {
            this.flags = null;
        } else {
            String flagString = flags.stream().map(ExpandableStringEnum::toString).collect(Collectors.joining("|"));
            this.flags = RegexFlags.fromString(flagString);
        }
        return this;
    }

    public Integer getGroup() {
        return this.group;
    }

    public PatternTokenizer setGroup(Integer group) {
        this.group = group;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("pattern", this.pattern);
        jsonWriter.writeStringField("flags", this.flags == null ? null : this.flags.toString());
        jsonWriter.writeNumberField("group", (Number)this.group);
        return jsonWriter.writeEndObject();
    }

    public static PatternTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return (PatternTokenizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.PatternTokenizer";
            String pattern = null;
            RegexFlags flags = null;
            Integer group = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("pattern".equals(fieldName)) {
                    pattern = reader.getString();
                    continue;
                }
                if ("flags".equals(fieldName)) {
                    flags = RegexFlags.fromString(reader.getString());
                    continue;
                }
                if ("group".equals(fieldName)) {
                    group = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                PatternTokenizer deserializedPatternTokenizer = new PatternTokenizer(name);
                deserializedPatternTokenizer.odataType = odataType;
                deserializedPatternTokenizer.pattern = pattern;
                deserializedPatternTokenizer.flags = flags;
                deserializedPatternTokenizer.group = group;
                return deserializedPatternTokenizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    public PatternTokenizer setFlags(RegexFlags ... flags) {
        if (flags == null) {
            this.flags = null;
            return this;
        }
        return this.setFlags(Arrays.asList(flags));
    }
}

