/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.AzureActiveDirectoryApplicationCredentials;
import java.io.IOException;
import java.util.ArrayList;

public final class SearchResourceEncryptionKey
implements JsonSerializable<SearchResourceEncryptionKey> {
    private final String keyName;
    private final String keyVersion;
    private final String vaultUrl;
    private AzureActiveDirectoryApplicationCredentials accessCredentials;

    public SearchResourceEncryptionKey(String keyName, String keyVersion, String vaultUrl) {
        this.keyName = keyName;
        this.keyVersion = keyVersion;
        this.vaultUrl = vaultUrl;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultKeyName", this.keyName);
        jsonWriter.writeStringField("keyVaultKeyVersion", this.keyVersion);
        jsonWriter.writeStringField("keyVaultUri", this.vaultUrl);
        jsonWriter.writeJsonField("accessCredentials", (JsonSerializable)this.accessCredentials);
        return jsonWriter.writeEndObject();
    }

    public static SearchResourceEncryptionKey fromJson(JsonReader jsonReader) throws IOException {
        return (SearchResourceEncryptionKey)jsonReader.readObject(reader -> {
            boolean keyNameFound = false;
            String keyName = null;
            boolean keyVersionFound = false;
            String keyVersion = null;
            boolean vaultUrlFound = false;
            String vaultUrl = null;
            AzureActiveDirectoryApplicationCredentials accessCredentials = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultKeyName".equals(fieldName)) {
                    keyName = reader.getString();
                    keyNameFound = true;
                    continue;
                }
                if ("keyVaultKeyVersion".equals(fieldName)) {
                    keyVersion = reader.getString();
                    keyVersionFound = true;
                    continue;
                }
                if ("keyVaultUri".equals(fieldName)) {
                    vaultUrl = reader.getString();
                    vaultUrlFound = true;
                    continue;
                }
                if ("accessCredentials".equals(fieldName)) {
                    accessCredentials = AzureActiveDirectoryApplicationCredentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (keyNameFound && keyVersionFound && vaultUrlFound) {
                SearchResourceEncryptionKey deserializedSearchResourceEncryptionKey = new SearchResourceEncryptionKey(keyName, keyVersion, vaultUrl);
                deserializedSearchResourceEncryptionKey.accessCredentials = accessCredentials;
                return deserializedSearchResourceEncryptionKey;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!keyNameFound) {
                missingProperties.add("keyVaultKeyName");
            }
            if (!keyVersionFound) {
                missingProperties.add("keyVaultKeyVersion");
            }
            if (!vaultUrlFound) {
                missingProperties.add("keyVaultUri");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public String getApplicationId() {
        return this.accessCredentials == null ? null : this.accessCredentials.getApplicationId();
    }

    public SearchResourceEncryptionKey setApplicationId(String applicationId) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationId(applicationId);
        return this;
    }

    public String getApplicationSecret() {
        return this.accessCredentials == null ? null : this.accessCredentials.getApplicationSecret();
    }

    public SearchResourceEncryptionKey setApplicationSecret(String applicationSecret) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationSecret(applicationSecret);
        return this;
    }
}

