/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.specialized.BlobLeaseAsyncClient;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;

public final class BlobLeaseClient {
    private final BlobLeaseAsyncClient client;

    BlobLeaseClient(BlobLeaseAsyncClient client) {
        this.client = client;
    }

    public String getResourceUrl() {
        return this.client.getResourceUrl();
    }

    public String getLeaseId() {
        return this.client.getLeaseId();
    }

    public String acquireLease(int duration) {
        return (String)this.acquireLeaseWithResponse(duration, null, null, Context.NONE).getValue();
    }

    public Response<String> acquireLeaseWithResponse(int duration, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.acquireLeaseWithResponse(duration, modifiedRequestConditions, context), (Duration)timeout);
    }

    public String renewLease() {
        return (String)this.renewLeaseWithResponse(null, null, Context.NONE).getValue();
    }

    public Response<String> renewLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.renewLeaseWithResponse(modifiedRequestConditions, context), (Duration)timeout);
    }

    public void releaseLease() {
        this.releaseLeaseWithResponse(null, null, Context.NONE);
    }

    public Response<Void> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.releaseLeaseWithResponse(modifiedRequestConditions, context), (Duration)timeout);
    }

    public Integer breakLease() {
        return (Integer)this.breakLeaseWithResponse(null, null, null, Context.NONE).getValue();
    }

    public Response<Integer> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.breakLeaseWithResponse(breakPeriodInSeconds, modifiedRequestConditions, context), (Duration)timeout);
    }

    public String changeLease(String proposedId) {
        return (String)this.changeLeaseWithResponse(proposedId, null, null, Context.NONE).getValue();
    }

    public Response<String> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.changeLeaseWithResponse(proposedId, modifiedRequestConditions, context), (Duration)timeout);
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }
}

