/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Resource;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.DiskInner;
import com.azure.resourcemanager.compute.models.AccessLevel;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.CreationSource;
import com.azure.resourcemanager.compute.models.Disk;
import com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.azure.resourcemanager.compute.models.DiskSku;
import com.azure.resourcemanager.compute.models.DiskSkuTypes;
import com.azure.resourcemanager.compute.models.DiskStorageAccountTypes;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.EncryptionType;
import com.azure.resourcemanager.compute.models.GrantAccessData;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.Snapshot;
import com.azure.resourcemanager.compute.models.SnapshotSkuType;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DiskImpl
extends GroupableResourceImpl<Disk, DiskInner, DiskImpl, ComputeManager>
implements Disk,
Disk.Definition,
Disk.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    DiskImpl(String name, DiskInner innerModel, ComputeManager computeManager) {
        super(name, (Resource)innerModel, (Manager)computeManager);
    }

    @Override
    public DiskSkuTypes sku() {
        return DiskSkuTypes.fromDiskSku(((DiskInner)((Object)this.innerModel())).sku());
    }

    @Override
    public DiskCreateOption creationMethod() {
        return ((DiskInner)((Object)this.innerModel())).creationData().createOption();
    }

    @Override
    public boolean isAttachedToVirtualMachine() {
        return this.virtualMachineId() != null;
    }

    @Override
    public String virtualMachineId() {
        return ((DiskInner)((Object)this.innerModel())).managedBy();
    }

    @Override
    public int sizeInGB() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((DiskInner)((Object)this.innerModel())).diskSizeGB());
    }

    @Override
    public long sizeInByte() {
        return ((DiskInner)((Object)this.innerModel())).diskSizeBytes();
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((DiskInner)((Object)this.innerModel())).osType();
    }

    @Override
    public CreationSource source() {
        return new CreationSource(((DiskInner)((Object)this.innerModel())).creationData());
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((DiskInner)((Object)this.innerModel())).zones() != null) {
            for (String zone : ((DiskInner)((Object)this.innerModel())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public EncryptionSettingsCollection encryptionSettings() {
        return ((DiskInner)((Object)this.innerModel())).encryptionSettingsCollection();
    }

    @Override
    public Encryption encryption() {
        return ((DiskInner)((Object)this.innerModel())).encryption();
    }

    @Override
    public String grantAccess(int accessDurationInSeconds) {
        return (String)this.grantAccessAsync(accessDurationInSeconds).block();
    }

    @Override
    public Mono<String> grantAccessAsync(int accessDurationInSeconds) {
        GrantAccessData grantAccessDataInner = new GrantAccessData();
        grantAccessDataInner.withAccess(AccessLevel.READ).withDurationInSeconds(accessDurationInSeconds);
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().grantAccessAsync(this.resourceGroupName(), this.name(), grantAccessDataInner).map(accessUriInner -> accessUriInner.accessSas());
    }

    @Override
    public void revokeAccess() {
        this.revokeAccessAsync().block();
    }

    @Override
    public Mono<Void> revokeAccessAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().revokeAccessAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public DiskImpl withLinuxFromVhd(String vhdUrl) {
        ((DiskInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public DiskImpl withLinuxFromDisk(String sourceDiskId) {
        ((DiskInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public DiskImpl withLinuxFromDisk(Disk sourceDisk) {
        this.withLinuxFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public DiskImpl withLinuxFromSnapshot(String sourceSnapshotId) {
        ((DiskInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public DiskImpl withLinuxFromSnapshot(Snapshot sourceSnapshot) {
        this.withLinuxFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(this.fromSnapshotSkuType(sourceSnapshot.skuType()));
        return this;
    }

    @Override
    public DiskImpl withWindowsFromVhd(String vhdUrl) {
        ((DiskInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public DiskImpl withWindowsFromDisk(String sourceDiskId) {
        ((DiskInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public DiskImpl withWindowsFromDisk(Disk sourceDisk) {
        this.withWindowsFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public DiskImpl withWindowsFromSnapshot(String sourceSnapshotId) {
        ((DiskInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public DiskImpl withWindowsFromSnapshot(Snapshot sourceSnapshot) {
        this.withWindowsFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(this.fromSnapshotSkuType(sourceSnapshot.skuType()));
        return this;
    }

    @Override
    public DiskImpl withData() {
        ((DiskInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.EMPTY);
        return this;
    }

    @Override
    public DiskImpl fromVhd(String vhdUrl) {
        ((DiskInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public DiskImpl withUploadSizeInMB(long uploadSizeInMB) {
        ((DiskInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.UPLOAD).withUploadSizeBytes(uploadSizeInMB * 1024L * 1024L + 512L);
        return this;
    }

    @Override
    public DiskImpl fromSnapshot(String snapshotId) {
        ((DiskInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(snapshotId);
        return this;
    }

    @Override
    public DiskImpl fromSnapshot(Snapshot snapshot) {
        return this.fromSnapshot(snapshot.id());
    }

    @Override
    public DiskImpl fromDisk(String managedDiskId) {
        ((DiskInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(managedDiskId);
        return this;
    }

    @Override
    public DiskImpl fromDisk(Disk managedDisk) {
        return this.fromDisk(managedDisk.id()).withOSType(managedDisk.osType()).withSku(managedDisk.sku());
    }

    @Override
    public DiskImpl withSizeInGB(int sizeInGB) {
        ((DiskInner)((Object)this.innerModel())).withDiskSizeGB(sizeInGB);
        return this;
    }

    @Override
    public DiskImpl withOSType(OperatingSystemTypes osType) {
        ((DiskInner)((Object)this.innerModel())).withOsType(osType);
        return this;
    }

    @Override
    public DiskImpl withSku(DiskSkuTypes sku) {
        ((DiskInner)((Object)this.innerModel())).withSku(new DiskSku().withName(sku.accountType()));
        return this;
    }

    @Override
    public DiskImpl withStorageAccountId(String storageAccountId) {
        ((DiskInner)((Object)this.innerModel())).creationData().withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public DiskImpl withStorageAccountName(String storageAccountName) {
        String id = ResourceUtils.constructResourceId((String)((ComputeManager)this.myManager).subscriptionId(), (String)this.resourceGroupName(), (String)"Microsoft.Storage", (String)"storageAccounts", (String)storageAccountName, (String)"");
        return this.withStorageAccountId(id);
    }

    @Override
    public DiskImpl withStorageAccount(StorageAccount account) {
        return this.withStorageAccountId(account.id());
    }

    @Override
    public DiskImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((DiskInner)((Object)this.innerModel())).zones() == null) {
            ((DiskInner)((Object)this.innerModel())).withZones(new ArrayList<String>());
        }
        ((DiskInner)((Object)this.innerModel())).zones().add(zoneId.toString());
        return this;
    }

    @Override
    public DiskImpl withDiskEncryptionSet(String diskEncryptionSetId) {
        Encryption encryption = ((DiskInner)((Object)this.innerModel())).encryption();
        if (encryption == null) {
            encryption = new Encryption();
            ((DiskInner)((Object)this.innerModel())).withEncryption(encryption);
        }
        encryption.withDiskEncryptionSetId(diskEncryptionSetId);
        return this;
    }

    @Override
    public DiskImpl withDiskEncryptionSet(String diskEncryptionSetId, EncryptionType encryptionType) {
        Encryption encryption = ((DiskInner)((Object)this.innerModel())).encryption();
        if (encryption == null) {
            encryption = new Encryption();
            ((DiskInner)((Object)this.innerModel())).withEncryption(encryption);
        }
        encryption.withType(encryptionType);
        encryption.withDiskEncryptionSetId(diskEncryptionSetId);
        return this;
    }

    public Mono<Disk> createResourceAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().createOrUpdateAsync(this.resourceGroupName(), this.name(), (DiskInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<DiskInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Accepted<Disk> beginCreate() {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDisks().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), (DiskInner)((Object)((Object)this.innerModel()))).block(), inner -> new DiskImpl(inner.name(), (DiskInner)((Object)inner), (ComputeManager)this.manager()), DiskInner.class, () -> {
            Flux dependencyTasksAsync = this.taskGroup().invokeDependencyAsync(this.taskGroup().newInvocationContext());
            dependencyTasksAsync.blockLast();
        }, arg_0 -> ((DiskImpl)this).setInner(arg_0), (Context)Context.NONE);
    }

    private DiskSkuTypes fromSnapshotSkuType(SnapshotSkuType skuType) {
        if (skuType == null) {
            return null;
        }
        return DiskSkuTypes.fromStorageAccountType(DiskStorageAccountTypes.fromString(skuType.toString()));
    }
}

