/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.model.AbstractBceRequest;
import com.google.common.base.Preconditions;

public abstract class GenericBucketRequest
extends AbstractBceRequest {
    private static final int MIN_BUCKET_NAME_LENGTH = 3;
    private static final int MAX_BUCKET_NAME_LENGTH = 63;
    private String bucketName;

    public GenericBucketRequest() {
    }

    public GenericBucketRequest(String bucketName) {
        this.setBucketName(bucketName);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        Preconditions.checkNotNull((Object)bucketName, (Object)"bucketName should not be null.");
        bucketName = bucketName.trim();
        if (bucketName.length() < 3) {
            throw new IllegalArgumentException("Invalid bucketName:" + bucketName + ". " + "bucketName should not be less than " + 3 + ".");
        }
        if (bucketName.length() > 63) {
            throw new IllegalArgumentException("Invalid bucketName:" + bucketName + ". " + "bucketName should not be greater than " + 63 + ".");
        }
        if (!GenericBucketRequest.isLowercaseOrDigit(bucketName.charAt(0))) {
            throw new IllegalArgumentException("Invalid bucketName:" + bucketName + ". " + "bucketName should start with a lowercase letter or digit.");
        }
        if (!GenericBucketRequest.isLowercaseOrDigit(bucketName.charAt(bucketName.length() - 1))) {
            throw new IllegalArgumentException("Invalid bucketName:" + bucketName + ". " + "bucketName should end with a lowercase letter or digit.");
        }
        for (int i = 1; i < bucketName.length() - 1; ++i) {
            char ch = bucketName.charAt(i);
            if (GenericBucketRequest.isLowercaseOrDigit(ch) || ch == '-') continue;
            throw new IllegalArgumentException("Invalid bucketName:" + bucketName + ". " + "bucketName should contain only lowercase leters, " + "digits and hyphens(-).");
        }
        this.bucketName = bucketName;
    }

    public abstract GenericBucketRequest withBucketName(String var1);

    private static boolean isLowercaseOrDigit(char ch) {
        return Character.isDigit(ch) || ch >= 'a' && ch <= 'z';
    }
}

