/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus;

import com.baomidou.mybatisplus.annotations.IdType;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.baomidou.mybatisplus.toolkit.TableInfo;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MybatisDefaultParameterHandler
extends DefaultParameterHandler {
    public MybatisDefaultParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        super(mappedStatement, MybatisDefaultParameterHandler.processBatch(mappedStatement, parameterObject), boundSql);
    }

    protected static Object processBatch(MappedStatement ms, Object parameterObject) {
        Collection<Object> parameters = MybatisDefaultParameterHandler.getParameters(parameterObject);
        if (parameters != null) {
            ArrayList<Object> objList = new ArrayList<Object>();
            for (Object parameter : parameters) {
                objList.add(MybatisDefaultParameterHandler.populateKeys(ms, parameter));
            }
            return objList;
        }
        return MybatisDefaultParameterHandler.populateKeys(ms, parameterObject);
    }

    protected static Collection<Object> getParameters(Object parameter) {
        List<Object> parameters = null;
        if (parameter instanceof Collection) {
            parameters = (List<Object>)parameter;
        } else if (parameter instanceof Map) {
            Map parameterMap = (Map)parameter;
            if (parameterMap.containsKey("collection")) {
                parameters = (Collection)parameterMap.get("collection");
            } else if (parameterMap.containsKey("list")) {
                parameters = (List)parameterMap.get("list");
            } else if (parameterMap.containsKey("array")) {
                parameters = Arrays.asList((Object[])parameterMap.get("array"));
            }
        }
        return parameters;
    }

    protected static Object populateKeys(MappedStatement ms, Object parameterObject) {
        TableInfo tableInfo;
        if (ms.getSqlCommandType() == SqlCommandType.INSERT && (tableInfo = TableInfoHelper.getTableInfo(parameterObject.getClass())) != null && tableInfo.getIdType().getKey() >= 2) {
            MetaObject metaParam = ms.getConfiguration().newMetaObject(parameterObject);
            Object idValue = metaParam.getValue(tableInfo.getKeyProperty());
            if (idValue == null) {
                if (tableInfo.getIdType() == IdType.ID_WORKER) {
                    metaParam.setValue(tableInfo.getKeyProperty(), (Object)IdWorker.getId());
                } else if (tableInfo.getIdType() == IdType.UUID) {
                    metaParam.setValue(tableInfo.getKeyProperty(), (Object)MybatisDefaultParameterHandler.get32UUID());
                }
            }
            return metaParam.getOriginalObject();
        }
        return parameterObject;
    }

    protected static synchronized String get32UUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

