/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityWrapper<T> {
    private T entity = null;
    private String sqlSegment = null;
    private String orderByField = null;

    protected EntityWrapper() {
    }

    public EntityWrapper(T entity) {
        this.entity = entity;
    }

    public EntityWrapper(T entity, String orderByField) {
        this.entity = entity;
        this.orderByField = orderByField;
    }

    public EntityWrapper(T entity, String sqlSegment, String orderByField) {
        this.entity = entity;
        this.sqlSegment = sqlSegment;
        this.orderByField = orderByField;
    }

    public T getEntity() {
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public String getSqlSegment() {
        if (this.sqlSegment == null && this.orderByField == null) {
            return null;
        }
        StringBuffer andOrSql = new StringBuffer();
        if (this.sqlSegment != null) {
            andOrSql.append(this.sqlSegment);
        }
        if (this.orderByField != null) {
            andOrSql.append(" ORDER BY ").append(this.orderByField);
        }
        return this.stripSqlInjection(andOrSql.toString());
    }

    public void setSqlSegment(String sqlSegment) {
        if (sqlSegment != null && !"".equals(sqlSegment)) {
            this.sqlSegment = sqlSegment;
        }
    }

    public String getOrderByField() {
        return this.orderByField;
    }

    public void setOrderByField(String orderByField) {
        if (orderByField != null && !"".equals(orderByField)) {
            this.orderByField = orderByField;
        }
    }

    protected String stripSqlInjection(String value) {
        return value.replaceAll("('.+--)|(--)|(\\|)|(%7C)", "");
    }
}

