/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.activerecord;

import com.baomidou.mybatisplus.enums.SqlMethod;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.SqlRunner;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model<T extends Model>
implements Serializable {
    public boolean insert() {
        return SqlHelper.retBool(this.sqlSession().insert(this.sqlStatement(SqlMethod.INSERT_ONE), (Object)this));
    }

    public boolean insertOrUpdate() {
        if (StringUtils.checkValNotNull(this.pkVal())) {
            return SqlHelper.retBool(this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), (Object)this));
        }
        return SqlHelper.retBool(this.sqlSession().insert(this.sqlStatement(SqlMethod.INSERT_ONE), (Object)this));
    }

    public boolean deleteById(Serializable id) {
        return SqlHelper.retBool(this.sqlSession().delete(this.sqlStatement(SqlMethod.DELETE_BY_ID), (Object)id));
    }

    public boolean deleteById() {
        if (StringUtils.checkValNull(this.pkVal())) {
            throw new MybatisPlusException("deleteById primaryKey is null.");
        }
        return this.deleteById(this.pkVal());
    }

    public boolean delete(String whereClause, Object ... args) {
        return this.delete(Condition.instance().where(whereClause, args));
    }

    public boolean delete(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        map.put("ew", wrapper);
        return SqlHelper.retBool(this.sqlSession().delete(this.sqlStatement(SqlMethod.DELETE), map));
    }

    public boolean updateById() {
        if (StringUtils.checkValNull(this.pkVal())) {
            throw new MybatisPlusException("updateById primaryKey is null.");
        }
        return SqlHelper.retBool(this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), (Object)this));
    }

    public boolean update(String whereClause, Object ... args) {
        return this.update(Condition.instance().where(whereClause, args));
    }

    public boolean update(Wrapper wrapper) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("et", this);
        map.put("ew", wrapper);
        return SqlHelper.retBool(this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE), map));
    }

    public List<T> selectAll() {
        return this.sqlSession().selectList(this.sqlStatement(SqlMethod.SELECT_LIST));
    }

    public T selectById(Serializable id) {
        return (T)((Model)this.sqlSession().selectOne(this.sqlStatement(SqlMethod.SELECT_BY_ID), (Object)id));
    }

    public T selectById() {
        if (StringUtils.checkValNull(this.pkVal())) {
            throw new MybatisPlusException("selectById primaryKey is null.");
        }
        return this.selectById(this.pkVal());
    }

    public List<T> selectList(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        map.put("ew", wrapper);
        return this.sqlSession().selectList(this.sqlStatement(SqlMethod.SELECT_LIST), map);
    }

    public List<T> selectList(String whereClause, Object ... args) {
        return this.selectList(Condition.instance().where(whereClause, args));
    }

    public T selectOne(Wrapper wrapper) {
        return (T)((Model)SqlHelper.getObject(this.selectList(wrapper)));
    }

    public T selectOne(String whereClause, Object ... args) {
        return this.selectOne(Condition.instance().where(whereClause, args));
    }

    public Page<T> selectPage(Page<T> page, Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        if (wrapper != null && StringUtils.isNotEmpty(page.getOrderByField())) {
            wrapper.orderBy(page.getOrderByField());
        }
        map.put("ew", wrapper);
        List tl = this.sqlSession().selectList(this.sqlStatement(SqlMethod.SELECT_PAGE), map, page);
        page.setRecords(tl);
        return page;
    }

    public Page<T> selectPage(Page<T> page, String whereClause, Object ... args) {
        return this.selectPage(page, Condition.instance().where(whereClause, args));
    }

    public int selectCount(String whereClause, Object ... args) {
        return this.selectCount(Condition.instance().where(whereClause, args));
    }

    public int selectCount(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        map.put("ew", wrapper);
        return SqlHelper.retCount((Integer)this.sqlSession().selectOne(this.sqlStatement(SqlMethod.SELECT_COUNT), map));
    }

    public SqlRunner sql() {
        return new SqlRunner(this.getClass());
    }

    private SqlSession sqlSession() {
        return SqlHelper.sqlSession(this.getClass());
    }

    private String sqlStatement(SqlMethod sqlMethod) {
        return this.sqlStatement(sqlMethod.getMethod());
    }

    private String sqlStatement(String sqlMethod) {
        return SqlHelper.table(this.getClass()).getSqlStatement(sqlMethod);
    }

    protected abstract Serializable pkVal();
}

