/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.generator.config.rules.DbType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DataSourceConfig {
    private DbType dbType;
    private String url;
    private String driverName;
    private String username;
    private String password;

    public DbType getDbType() {
        if (null == this.dbType) {
            if (this.driverName.contains("mysql")) {
                this.dbType = DbType.MYSQL;
            } else if (this.driverName.contains("oracle")) {
                this.dbType = DbType.ORACLE;
            } else if (this.driverName.contains("postgresql")) {
                this.dbType = DbType.POSTGRE_SQL;
            } else {
                throw new MybatisPlusException("Unknown type of database!");
            }
        }
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public Connection getConn() {
        Connection conn = null;
        try {
            Class.forName(this.driverName);
            conn = DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

