/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.pagination;

import com.baomidou.mybatisplus.enums.DBType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.pagination.IDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.DB2Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.H2Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.HSQLDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.MySqlDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.OracleDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.PostgreDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLServer2005Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLServerDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLiteDialect;

public class DialectFactory {
    public static IDialect getDialectByDbtype(String dbtype) throws Exception {
        if (DBType.MYSQL.getDb().equalsIgnoreCase(dbtype)) {
            return new MySqlDialect();
        }
        if (DBType.ORACLE.getDb().equalsIgnoreCase(dbtype)) {
            return new OracleDialect();
        }
        if (DBType.DB2.getDb().equalsIgnoreCase(dbtype)) {
            return new DB2Dialect();
        }
        if (DBType.H2.getDb().equalsIgnoreCase(dbtype)) {
            return new H2Dialect();
        }
        if (DBType.SQLSERVER.getDb().equalsIgnoreCase(dbtype)) {
            return new SQLServerDialect();
        }
        if (DBType.SQLSERVER2005.getDb().equalsIgnoreCase(dbtype)) {
            return new SQLServer2005Dialect();
        }
        if (DBType.POSTGRE.getDb().equalsIgnoreCase(dbtype)) {
            return new PostgreDialect();
        }
        if (DBType.HSQL.getDb().equalsIgnoreCase(dbtype)) {
            return new HSQLDialect();
        }
        if (DBType.SQLITE.getDb().equalsIgnoreCase(dbtype)) {
            return new SQLiteDialect();
        }
        throw new MybatisPlusException("The database is not supported\uff01dbtype:" + dbtype);
    }
}

