/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.JsonUtil;
import com.bazaarvoice.jolt.JsonUtilImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static final JsonUtil util = new JsonUtilImpl();

    public static JsonUtil customJsonUtil(ObjectMapper mapper) {
        return new JsonUtilImpl(mapper);
    }

    @Deprecated
    public static void removeRecursive(Object json, String keyToRemove) {
        if (json == null || keyToRemove == null) {
            return;
        }
        if (json instanceof Map) {
            Map jsonMap = (Map)json;
            if (jsonMap.containsKey(keyToRemove)) {
                jsonMap.remove(keyToRemove);
            }
            for (Object value : jsonMap.values()) {
                JsonUtils.removeRecursive(value, keyToRemove);
            }
        }
        if (json instanceof List) {
            for (Object value : (List)json) {
                JsonUtils.removeRecursive(value, keyToRemove);
            }
        }
    }

    public static Map<String, Object> javason(String javason) {
        String json = javason.replace('\'', '\"');
        return JsonUtils.jsonToMap(new ByteArrayInputStream(json.getBytes()));
    }

    public static JsonUtil getDefaultJsonUtil() {
        return util;
    }

    public static Object jsonToObject(String json) {
        return util.jsonToObject(json);
    }

    public static Object jsonToObject(String json, String charset) {
        return util.jsonToObject(json, charset);
    }

    public static Object jsonToObject(InputStream in) {
        return util.jsonToObject(in);
    }

    public static Map<String, Object> jsonToMap(String json) {
        return util.jsonToMap(json);
    }

    public static Map<String, Object> jsonToMap(String json, String charset) {
        return util.jsonToMap(json, charset);
    }

    public static Map<String, Object> jsonToMap(InputStream in) {
        return util.jsonToMap(in);
    }

    public static List<Object> jsonToList(String json) {
        return util.jsonToList(json);
    }

    public static List<Object> jsonToList(String json, String charset) {
        return util.jsonToList(json, charset);
    }

    public static List<Object> jsonToList(InputStream in) {
        return util.jsonToList(in);
    }

    public static Object filepathToObject(String filePath) {
        return util.filepathToObject(filePath);
    }

    public static Map<String, Object> filepathToMap(String filePath) {
        return util.filepathToMap(filePath);
    }

    public static List<Object> filepathToList(String filePath) {
        return util.filepathToList(filePath);
    }

    public static Object classpathToObject(String classPath) {
        return util.classpathToObject(classPath);
    }

    public static Map<String, Object> classpathToMap(String classPath) {
        return util.classpathToMap(classPath);
    }

    public static List<Object> classpathToList(String classPath) {
        return util.classpathToList(classPath);
    }

    public static <T> T classpathToType(String classPath, TypeReference<T> typeRef) {
        return util.classpathToType(classPath, typeRef);
    }

    public static <T> T classpathToType(String classPath, Class<T> aClass) {
        return util.classpathToType(classPath, aClass);
    }

    public static <T> T stringToType(String json, TypeReference<T> typeRef) {
        return util.stringToType(json, typeRef);
    }

    public static <T> T stringToType(String json, Class<T> aClass) {
        return util.stringToType(json, aClass);
    }

    public static <T> T fileToType(String filePath, TypeReference<T> typeRef) {
        return util.fileToType(filePath, typeRef);
    }

    public static <T> T fileToType(String filePath, Class<T> aClass) {
        return util.fileToType(filePath, aClass);
    }

    public static <T> T streamToType(InputStream in, TypeReference<T> typeRef) {
        return util.streamToType(in, typeRef);
    }

    public static <T> T streamToType(InputStream in, Class<T> aClass) {
        return util.streamToType(in, aClass);
    }

    @Deprecated
    public static <T> T jsonTo(String json, TypeReference<T> typeRef) {
        return util.stringToType(json, typeRef);
    }

    @Deprecated
    public static <T> T jsonTo(InputStream in, TypeReference<T> typeRef) {
        return util.streamToType(in, typeRef);
    }

    public static String toJsonString(Object obj) {
        return util.toJsonString(obj);
    }

    public static String toPrettyJsonString(Object obj) {
        return util.toPrettyJsonString(obj);
    }

    public static Object cloneJson(Object obj) {
        return util.cloneJson(obj);
    }

    @Deprecated
    public static <T> T navigate(Object source, Object ... paths) throws NullPointerException, UnsupportedOperationException {
        Object destination = source;
        for (Object path : paths) {
            if (destination == null) {
                throw new NullPointerException("Navigation not possible on null object");
            }
            if (destination instanceof Map) {
                destination = ((Map)destination).get(path);
                continue;
            }
            if (path instanceof Integer && destination instanceof List) {
                destination = ((List)destination).get((Integer)path);
                continue;
            }
            throw new UnsupportedOperationException("Navigation supports only Map and List source types and non-null String and Integer path types");
        }
        return (T)destination;
    }
}

