/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.management.PoolManConfiguration;
import com.frameworkset.util.SimpleStringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigParser
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger(ConfigParser.class);
    private ArrayList dbProps;
    private ArrayList genericProps;
    private Properties adminProps;
    private boolean jmxManagement = false;
    private String currentSet;
    private String currentName;
    private StringBuilder currentValue = new StringBuilder();
    private String file;
    private String[] filterdbname = null;
    private String interceptor = "com.frameworkset.common.poolman.interceptor.DummyInterceptor";
    private String currentdbtype;
    private String dbnamespace;
    protected PropertiesContainer configPropertiesFile;
    private Map<String, String> adaptors = new HashMap<String, String>();
    private List<Properties> filterpros = null;

    public ConfigParser(String file, String dbnamespace, String[] filterdbname) {
        this.dbProps = new ArrayList();
        this.genericProps = new ArrayList();
        this.file = file;
        this.filterdbname = filterdbname;
        this.dbnamespace = dbnamespace;
    }

    public ArrayList getDataSourceProperties() {
        if (this.filterdbname != null && this.filterdbname.length > 0) {
            this.dbProps.clear();
            if (this.filterpros != null && this.filterpros.size() > 0) {
                this.dbProps.addAll(this.filterpros);
            }
        }
        return this.dbProps;
    }

    public ArrayList getGenericProperties() {
        return this.genericProps;
    }

    public Properties getAdminProps() {
        return this.adminProps;
    }

    public boolean isManagementJMX() {
        return this.jmxManagement;
    }

    @Override
    public void startElement(String s1, String s2, String name, Attributes attributes) {
        this.currentValue.delete(0, this.currentValue.length());
        this.currentName = name;
        if (name.toLowerCase().equals("datasource")) {
            this.currentSet = "datasource";
            Properties properties = new Properties();
            String external = SimpleStringUtil.replaceNull((String)attributes.getValue("external"), (String)"false");
            properties.put("external", external);
            this.dbProps.add(properties);
        } else if (name.equals("config")) {
            String file;
            if (this.configPropertiesFile == null) {
                this.configPropertiesFile = new PropertiesContainer();
            }
            if ((file = attributes.getValue("file")) != null) {
                this.configPropertiesFile.addConfigPropertiesFile(file);
            }
        } else if (name.toLowerCase().equals("objectpool")) {
            this.currentSet = "generic";
            this.genericProps.add(new Properties());
        } else if (name.toLowerCase().equals("admin-agent")) {
            this.currentSet = "admin-agent";
            this.adminProps = new Properties();
        } else if (name.toLowerCase().equals("management-mode")) {
            this.currentSet = "management-mode";
        } else if (name.equals("poolman") || name.equals("MLET")) {
            this.currentSet = "ignorable";
        } else if (name.toLowerCase().equals("jndi_principal")) {
            this.currentSet = "jndi_principal";
        } else if (name.equals("jndi_credentials")) {
            this.currentSet = "jndi_credentials";
        } else if (name.toLowerCase().equals("adaptor")) {
            this.currentSet = "adaptor";
            this.currentdbtype = attributes.getValue("dbtype");
        } else if (!(name.equals("dbname") || name.equals("loadmetadata") || name.equals("jndiName") || name.equals("driver") || name.equals("url") || name.equals("username") || name.equals("password") || name.equals("txIsolationLevel") || name.equals("nativeResults") || name.equals("poolPreparedStatements") || name.equals("initialConnections") || name.equals("minimumSize") || name.equals("maximumSize") || name.equals("maximumSoft") || name.equals("removeAbandoned") || name.equals("userTimeout") || name.equals("logAbandoned") || name.equals("readOnly") || name.equals("skimmerFrequency") || name.equals("connectionTimeout") || name.equals("shrinkBy") || name.equals("testWhileidle") || name.equals("keygenerate") || name.equals("maxWait") || name.equals("validationQuery") || name.equals("autoprimarykey") || name.equals("cachequerymetadata") || name.equals("showsql") || name.equals("externaljndiName") || name.equals("enablejta") || name.equals("usepool") || name.equals("encryptdbinfo") || name.equals("datasourceFile") || name.equals("queryfetchsize") || name.equals("config") || name.equals("needtableinfo") || !log.isDebugEnabled())) {
            log.debug("\u89e3\u6790\u6587\u4ef6\u65f6[" + this.file + "]\u9047\u5230\u5143\u7d20[" + name + "]\uff0c\u5ffd\u7565\u5904\u7406\u3002");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentValue.append(ch, start, length);
    }

    private boolean contain(String newdbname) {
        if (this.filterpros == null || this.filterpros.size() == 0) {
            return false;
        }
        for (Properties p : this.filterpros) {
            String dbname = (String)p.get("dbname");
            if (!dbname.equals(newdbname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endElement(String s1, String s2, String name) {
        if (this.currentSet.equals("datasource")) {
            Properties p = (Properties)this.dbProps.get(this.dbProps.size() - 1);
            if (name.toLowerCase().equals("dbname")) {
                String dbname;
                String temp = dbname = this.currentValue.toString().trim();
                if (this.dbnamespace != null && !this.dbnamespace.equals("")) {
                    dbname = this.dbnamespace + ":" + this.currentValue.toString().trim();
                }
                p.put(name.toLowerCase(), dbname);
                if (this.filterdbname != null && this.filterdbname.length > 0) {
                    for (String _dbname : this.filterdbname) {
                        if (!temp.equals(_dbname)) continue;
                        if (this.filterpros == null) {
                            this.filterpros = new ArrayList<Properties>();
                        }
                        this.filterpros.add(p);
                        break;
                    }
                }
            } else {
                String value = null;
                value = this.configPropertiesFile != null ? this.configPropertiesFile.evalValue(this.currentValue.toString().trim(), null) : this.currentValue.toString().trim();
                if (!name.equals("password")) {
                    p.put(name.toLowerCase(), value.trim());
                } else {
                    p.put(name.toLowerCase(), value);
                }
            }
        } else if (this.currentSet.equals("generic")) {
            Properties p = (Properties)this.genericProps.get(this.genericProps.size() - 1);
            p.put(name.toLowerCase(), this.currentValue.toString().trim());
        } else if (this.currentSet.equals("admin-agent")) {
            this.adminProps.setProperty(name.toLowerCase(), this.currentValue.toString().trim());
        } else if (this.currentSet.equals("management-mode")) {
            if (this.currentValue.toString().toLowerCase().trim().equals("jmx")) {
                this.jmxManagement = true;
            }
        } else if (this.currentSet.equals("jndi_principal")) {
            if (this.currentValue.toString().trim().length() > 0) {
                PoolManConfiguration.jndi_principal = this.currentValue.toString();
            }
        } else if (this.currentSet.equals("jndi_credentials")) {
            if (this.currentValue.toString().trim().length() > 0) {
                PoolManConfiguration.jndi_credentials = this.currentValue.toString();
            }
        } else if (this.currentSet.equals("adaptor")) {
            if (this.currentValue.toString().trim().length() > 0) {
                if (this.currentdbtype == null || this.currentdbtype.equals("")) {
                    System.out.println("ignoe adaptor[" + this.currentValue + "],\u6ca1\u6709\u6307\u5b9adbtype\u3002");
                } else {
                    this.adaptors.put(this.currentdbtype, this.currentValue.toString().trim());
                    this.currentdbtype = null;
                }
            }
        } else if (name.equals("needtableinfo")) {
            PoolManConfiguration.needtableinfo = this.currentValue.toString().trim().equals("true");
        }
        this.currentValue.delete(0, this.currentValue.length());
    }

    public Map<String, String> getAdaptors() {
        return this.adaptors;
    }

    public void setAdaptors(Map<String, String> adaptors) {
        this.adaptors = adaptors;
    }

    public String getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(String interceptor) {
        this.interceptor = interceptor;
    }
}

