/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.management.BaseTableManager;
import com.frameworkset.common.poolman.management.JMXPoolDeployer;
import com.frameworkset.common.poolman.management.LocalPoolDeployer;
import com.frameworkset.common.poolman.management.PoolManConfiguration;
import com.frameworkset.common.poolman.sql.PoolMan;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.orm.adapter.DBFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolManBootstrap {
    private static Logger log = LoggerFactory.getLogger(PoolManBootstrap.class);
    private String configFile = "poolman.xml";
    private static Map<String, Boolean> startedFile = new HashMap<String, Boolean>();

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            PoolManBootstrap inc = new PoolManBootstrap();
            inc.start();
        } else if (args.length == 1) {
            new PoolManBootstrap(args[0]).start();
        } else {
            System.out.println("SYNTAX: java -Djava.security.policy=[your policy file] com.frameworkset.common.poolman.management.PoolManBootstrap [optional: config file name]");
            System.exit(1);
        }
    }

    public PoolManBootstrap() {
        log.debug("construct poolmanbootstrap");
    }

    public PoolManBootstrap(String configFile) {
        this.configFile = configFile;
    }

    public void reStart(String configFile) throws Exception {
    }

    public void start() {
        try {
            this.start(this.configFile);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void startFromTemplte(Map<String, Object> values) {
        BaseTableManager deployer;
        log.debug("PoolManBootstrap(configFile): poolman_template.xml");
        PoolManConfiguration config = new PoolManConfiguration("poolman_template.xml", null);
        try {
            config.loadConfiguration(values);
        }
        catch (Exception ex) {
            log.error("Start(configFile) loadConfiguration error: " + ex.getMessage());
        }
        if (config.isUsingJMX()) {
            deployer = new JMXPoolDeployer(null);
            try {
                deployer.deployConfiguration(config);
            }
            catch (Exception ex1) {
                log.error("Start(configFile) deployConfiguration error: " + ex1.getMessage());
            }
        } else {
            DBFactory.addDBAdaptors(config.getAdaptors());
            deployer = new LocalPoolDeployer();
            try {
                deployer.deployConfiguration(config, null);
            }
            catch (Exception ex2) {
                log.error("LocalPoolDeployer deployConfiguration error: " + ex2.getMessage(), (Throwable)ex2);
            }
        }
        if (deployer != null) {
            try {
                if (config.isNeedtableinfo()) {
                    BaseTableManager.initTableInfo((String)values.get("dbname"));
                }
            }
            catch (Exception e) {
                log.error("InitTableInfo: " + e.getMessage(), (Throwable)e);
                log.debug("Initial tableinfo failed!");
            }
        }
        PoolMan.STARTED = true;
    }

    public void start(String configFile) {
        BaseTableManager deployer;
        log.debug("PoolManBootstrap(configFile): " + configFile);
        PoolManConfiguration config = new PoolManConfiguration(configFile, null);
        try {
            config.loadConfiguration(null);
        }
        catch (Exception ex) {
            log.error("Start(configFile) loadConfiguration error: " + ex.getMessage(), (Throwable)ex);
        }
        if (config.isUsingJMX()) {
            deployer = new JMXPoolDeployer(null);
            try {
                deployer.deployConfiguration(config);
            }
            catch (Exception ex1) {
                log.error("Start(configFile) deployConfiguration error: " + ex1.getMessage(), (Throwable)ex1);
            }
        } else {
            DBFactory.addDBAdaptors(config.getAdaptors());
            deployer = new LocalPoolDeployer();
            try {
                deployer.deployConfiguration(config);
            }
            catch (Exception ex2) {
                log.error("LocalPoolDeployer deployConfiguration error: " + ex2.getMessage(), (Throwable)ex2);
            }
        }
        if (deployer != null) {
            try {
                if (config.isNeedtableinfo()) {
                    deployer.initTableInfo();
                }
            }
            catch (Exception e) {
                log.error("InitTableInfo: " + e.getMessage(), (Throwable)e);
                log.debug("Initial tableinfo failed!");
            }
        }
        PoolMan.STARTED = true;
    }

    public static void startDBSFromConf(String configFile, String dbnamespace, String[] startdbnames) {
        BaseTableManager deployer;
        log.debug("PoolManBootstrap(configFile): " + configFile);
        PoolManConfiguration config = new PoolManConfiguration(configFile, dbnamespace, startdbnames);
        try {
            config.loadConfiguration(null);
        }
        catch (Exception ex) {
            log.error("Start(configFile) loadConfiguration error: " + ex.getMessage(), (Throwable)ex);
        }
        if (config.isUsingJMX()) {
            deployer = new JMXPoolDeployer(null);
            try {
                deployer.deployConfiguration(config);
            }
            catch (Exception ex1) {
                log.error("Start(configFile) deployConfiguration error: " + ex1.getMessage(), (Throwable)ex1);
            }
        } else {
            DBFactory.addDBAdaptors(config.getAdaptors());
            deployer = new LocalPoolDeployer();
            try {
                deployer.deployConfiguration(config);
            }
            catch (Exception ex2) {
                log.error("LocalPoolDeployer deployConfiguration error: " + ex2.getMessage(), (Throwable)ex2);
            }
        }
        if (deployer != null) {
            try {
                if (config.isNeedtableinfo()) {
                    deployer.initTableInfo();
                }
            }
            catch (Exception e) {
                log.error("InitTableInfo: " + e.getMessage(), (Throwable)e);
                log.debug("Initial tableinfo failed!");
            }
        }
        PoolMan.STARTED = true;
    }

    public void startDB(String dbname) throws Exception {
        log.debug("PoolManBootstrap(configFile): " + this.configFile);
        if (dbname == null || dbname.equals("")) {
            dbname = SQLUtil.getSQLManager().getDefaultDBName();
        }
        PoolManConfiguration config = new PoolManConfiguration(this.configFile, dbname);
        config.loadConfiguration(null);
        LocalPoolDeployer deployer = new LocalPoolDeployer();
        deployer.deployConfiguration(config, dbname);
        if (deployer != null) {
            try {
                if (config.isNeedtableinfo()) {
                    BaseTableManager.initTableInfo(dbname);
                }
            }
            catch (Exception e) {
                log.error("InitTableInfo: " + e.getMessage(), (Throwable)e);
                log.debug("Initial tableinfo failed!");
                throw e;
            }
        }
    }

    public void stop() {
    }
}

