/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2;

import com.frameworkset.commons.dbcp2.DelegatingConnection;
import com.frameworkset.commons.dbcp2.DelegatingPreparedStatement;
import com.frameworkset.commons.dbcp2.PStmtKey;
import com.frameworkset.commons.dbcp2.PoolableCallableStatement;
import com.frameworkset.commons.dbcp2.PoolablePreparedStatement;
import com.frameworkset.commons.pool2.KeyedObjectPool;
import com.frameworkset.commons.pool2.KeyedPooledObjectFactory;
import com.frameworkset.commons.pool2.PooledObject;
import com.frameworkset.commons.pool2.impl.DefaultPooledObject;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;

public class PoolingConnection
extends DelegatingConnection<Connection>
implements KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    private KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> _pstmtPool = null;

    public PoolingConnection(Connection c) {
        super(c);
    }

    public void setStatementPool(KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pool) {
        this._pstmtPool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        block11: {
            try {
                if (null == this._pstmtPool) break block11;
                KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> oldpool = this._pstmtPool;
                this._pstmtPool = null;
                try {
                    oldpool.close();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLException("Cannot close connection", e);
                }
            }
            finally {
                try {
                    this.getDelegateInternal().close();
                }
                finally {
                    this.setClosedInternal(true);
                }
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql, autoGeneratedKeys));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(sql, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    protected PStmtKey createKey(String sql, int autoGeneratedKeys) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, autoGeneratedKeys);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, resultSetType, resultSetConcurrency);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, StatementType stmtType) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, resultSetType, resultSetConcurrency, stmtType);
    }

    protected PStmtKey createKey(String sql) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog);
    }

    protected PStmtKey createKey(String sql, StatementType stmtType) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, stmtType, null);
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    @Override
    public PooledObject<DelegatingPreparedStatement> makeObject(PStmtKey key) throws Exception {
        if (null == key) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        if (null == key.getResultSetType() && null == key.getResultSetConcurrency() && null == key.getAutoGeneratedKeys()) {
            if (key.getStmtType() == StatementType.PREPARED_STATEMENT) {
                PoolablePreparedStatement<PStmtKey> pps = new PoolablePreparedStatement<PStmtKey>(this.getDelegate().prepareStatement(key.getSql()), key, this._pstmtPool, this);
                return new DefaultPooledObject<DelegatingPreparedStatement>(pps);
            }
            return new DefaultPooledObject<DelegatingPreparedStatement>(new PoolableCallableStatement(this.getDelegate().prepareCall(key.getSql()), key, this._pstmtPool, this));
        }
        if (null == key.getResultSetType() && null == key.getResultSetConcurrency()) {
            PoolablePreparedStatement<PStmtKey> pps = new PoolablePreparedStatement<PStmtKey>(this.getDelegate().prepareStatement(key.getSql(), key.getAutoGeneratedKeys()), key, this._pstmtPool, this);
            return new DefaultPooledObject<DelegatingPreparedStatement>(pps);
        }
        if (key.getStmtType() == StatementType.PREPARED_STATEMENT) {
            PoolablePreparedStatement<PStmtKey> pps = new PoolablePreparedStatement<PStmtKey>(this.getDelegate().prepareStatement(key.getSql(), key.getResultSetType(), key.getResultSetConcurrency()), key, this._pstmtPool, this);
            return new DefaultPooledObject<DelegatingPreparedStatement>(pps);
        }
        return new DefaultPooledObject<DelegatingPreparedStatement>(new PoolableCallableStatement(this.getDelegate().prepareCall(key.getSql(), key.getResultSetType(), key.getResultSetConcurrency()), key, this._pstmtPool, this));
    }

    @Override
    public void destroyObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> p) throws Exception {
        p.getObject().getInnermostDelegate().close();
    }

    @Override
    public boolean validateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> p) {
        return true;
    }

    @Override
    public void activateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> p) throws Exception {
        p.getObject().activate();
    }

    @Override
    public void passivateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> p) throws Exception {
        DelegatingPreparedStatement dps = p.getObject();
        dps.clearParameters();
        dps.passivate();
    }

    @Override
    public String toString() {
        if (this._pstmtPool != null) {
            return "PoolingConnection: " + this._pstmtPool.toString();
        }
        return "PoolingConnection: null";
    }

    protected static enum StatementType {
        CALLABLE_STATEMENT,
        PREPARED_STATEMENT;

    }
}

