/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2.managed;

import com.frameworkset.commons.dbcp2.DelegatingPreparedStatement;
import com.frameworkset.commons.dbcp2.PStmtKey;
import com.frameworkset.commons.dbcp2.PoolableConnection;
import com.frameworkset.commons.dbcp2.PoolableConnectionFactory;
import com.frameworkset.commons.dbcp2.PoolingConnection;
import com.frameworkset.commons.dbcp2.managed.PoolableManagedConnection;
import com.frameworkset.commons.dbcp2.managed.TransactionRegistry;
import com.frameworkset.commons.dbcp2.managed.XAConnectionFactory;
import com.frameworkset.commons.pool2.PooledObject;
import com.frameworkset.commons.pool2.impl.DefaultPooledObject;
import com.frameworkset.commons.pool2.impl.GenericKeyedObjectPool;
import com.frameworkset.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import java.sql.Connection;
import javax.management.ObjectName;

public class PoolableManagedConnectionFactory
extends PoolableConnectionFactory {
    private final TransactionRegistry transactionRegistry;

    public PoolableManagedConnectionFactory(XAConnectionFactory connFactory, ObjectName dataSourceJmxName) {
        super(connFactory, dataSourceJmxName);
        this.transactionRegistry = connFactory.getTransactionRegistry();
    }

    @Override
    public synchronized PooledObject<PoolableConnection> makeObject() throws Exception {
        Connection conn = this.getConnectionFactory().createConnection();
        if (conn == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        this.initializeConnection(conn);
        if (this.getPoolStatements()) {
            conn = new PoolingConnection(conn);
            GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
            config.setMaxTotalPerKey(-1);
            config.setBlockWhenExhausted(false);
            config.setMaxWaitMillis(0L);
            config.setMaxIdlePerKey(1);
            config.setMaxTotal(this.getMaxOpenPreparedStatements());
            ObjectName dataSourceJmxName = this.getDataSourceJmxName();
            long connIndex = this.getConnectionIndex().getAndIncrement();
            if (dataSourceJmxName != null) {
                StringBuilder base = new StringBuilder(dataSourceJmxName.toString());
                base.append(",connectionpool=connections,connection=");
                base.append(Long.toString(connIndex));
                config.setJmxNameBase(base.toString());
                config.setJmxNamePrefix(",statementpool=statements");
            } else {
                config.setJmxEnabled(false);
            }
            GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement> stmtPool = new GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement>((PoolingConnection)conn, config);
            ((PoolingConnection)conn).setStatementPool(stmtPool);
            ((PoolingConnection)conn).setCacheState(this.getCacheState());
        }
        return new DefaultPooledObject<PoolableConnection>(new PoolableManagedConnection(this.transactionRegistry, conn, this.getPool()));
    }
}

