/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.engine.transform;

import com.frameworkset.orm.engine.model.Column;
import com.frameworkset.orm.engine.model.Database;
import com.frameworkset.orm.engine.model.Table;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToData
extends DefaultHandler
implements EntityResolver,
Serializable {
    private static Logger log = LoggerFactory.getLogger(XmlToData.class);
    private Database database;
    private List data;
    private String dtdFileName;
    private File dtdFile;
    private InputSource dataDTD;
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    public XmlToData(Database database, String dtdFilePath) throws MalformedURLException, IOException {
        this.database = database;
        this.dtdFile = new File(dtdFilePath);
        this.dtdFileName = "file://" + this.dtdFile.getName();
        this.dataDTD = new InputSource(this.dtdFile.toURL().openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseFile(String xmlFile) throws Exception {
        this.data = new ArrayList();
        SAXParser parser = saxFactory.newSAXParser();
        FileReader fr = new FileReader(xmlFile);
        BufferedReader br = new BufferedReader(fr);
        try {
            InputSource is = new InputSource(br);
            parser.parse(is, (DefaultHandler)this);
        }
        finally {
            br.close();
        }
        return this.data;
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        try {
            if (!rawName.equals("dataset")) {
                Table table = this.database.getTableByJavaName(rawName);
                if (table == null) {
                    throw new SAXException("Table '" + rawName + "' unknown");
                }
                ArrayList<ColumnValue> columnValues = new ArrayList<ColumnValue>();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Column col = table.getColumnByJavaName(attributes.getQName(i));
                    if (col == null) {
                        throw new SAXException("Column " + attributes.getQName(i) + " in table " + rawName + " unknown.");
                    }
                    String value = attributes.getValue(i);
                    columnValues.add(new ColumnValue(col, value));
                }
                this.data.add(new DataRow(table, columnValues));
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            if (this.dataDTD != null && this.dtdFileName.equals(systemId)) {
                log.info("Resolver: used " + this.dtdFile.getPath());
                return this.dataDTD;
            }
            log.info("Resolver: used " + systemId);
            return this.getInputSource(systemId);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public InputSource getInputSource(String urlString) throws IOException {
        URL url = new URL(urlString);
        InputSource src = new InputSource(url.openStream());
        return src;
    }

    static {
        saxFactory.setValidating(true);
    }

    public class ColumnValue {
        private Column col;
        private String val;

        public ColumnValue(Column col, String val) {
            this.col = col;
            this.val = val;
        }

        public Column getColumn() {
            return this.col;
        }

        public String getValue() {
            return this.val;
        }

        public String getEscapedValue() {
            StringBuilder sb = new StringBuilder();
            sb.append("'");
            sb.append(StringUtils.replace((String)this.val, (String)"'", (String)"''"));
            sb.append("'");
            return sb.toString();
        }
    }

    public class DataRow {
        private Table table;
        private List columnValues;

        public DataRow(Table table, List columnValues) {
            this.table = table;
            this.columnValues = columnValues;
        }

        public Table getTable() {
            return this.table;
        }

        public List getColumnValues() {
            return this.columnValues;
        }
    }
}

