/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import com.frameworkset.orm.annotation.Column;
import com.frameworkset.orm.annotation.ESDocAsUpsert;
import com.frameworkset.orm.annotation.ESId;
import com.frameworkset.orm.annotation.ESParentId;
import com.frameworkset.orm.annotation.ESRetryOnConflict;
import com.frameworkset.orm.annotation.ESRouting;
import com.frameworkset.orm.annotation.ESSource;
import com.frameworkset.orm.annotation.ESVersion;
import com.frameworkset.orm.annotation.ESVersionType;
import com.frameworkset.orm.annotation.IgnoreORMapping;
import com.frameworkset.orm.annotation.PrimaryKey;
import com.frameworkset.util.BeanUtils;
import com.frameworkset.util.EditorInf;
import com.frameworkset.util.ValueObjectUtil;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.soa.annotation.ExcludeField;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.LocalVariableTableParameterNameDiscoverer;
import org.frameworkset.util.ParameterNameDiscoverer;
import org.frameworkset.util.ParameterUtil;
import org.frameworkset.util.ReflectionUtils;
import org.frameworkset.util.annotations.Attribute;
import org.frameworkset.util.annotations.CookieValue;
import org.frameworkset.util.annotations.DataBind;
import org.frameworkset.util.annotations.IgnoreBind;
import org.frameworkset.util.annotations.MapKey;
import org.frameworkset.util.annotations.PathVariable;
import org.frameworkset.util.annotations.RequestBody;
import org.frameworkset.util.annotations.RequestHeader;
import org.frameworkset.util.annotations.RequestParam;
import org.frameworkset.util.annotations.wraper.AttributeWraper;
import org.frameworkset.util.annotations.wraper.ColumnWraper;
import org.frameworkset.util.annotations.wraper.CookieValueWraper;
import org.frameworkset.util.annotations.wraper.PathVariableWraper;
import org.frameworkset.util.annotations.wraper.RequestBodyWraper;
import org.frameworkset.util.annotations.wraper.RequestHeaderWraper;
import org.frameworkset.util.annotations.wraper.RequestParamWraper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassUtil.class);
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private static Map<Class, ClassInfo> classInfos = new HashMap<Class, ClassInfo>();
    private static Object lock = new Object();

    public static void destroy() {
        if (classInfos != null) {
            classInfos.clear();
            classInfos = null;
        }
    }

    public static ParameterNameDiscoverer getParameterNameDiscoverer() {
        return parameterNameDiscoverer;
    }

    public static final EditorInf getParamEditor(RequestParamWraper param) {
        if (param == null) {
            return null;
        }
        String editor = param.editor();
        if (editor != null && !editor.equals("")) {
            return (EditorInf)BeanUtils.instantiateClass(editor);
        }
        return null;
    }

    public static final RequestParamWraper getWriterMethodRequestParam(Method writeMethod) {
        if (writeMethod == null) {
            return null;
        }
        Annotation[] annotations = writeMethod.getAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof RequestParam)) continue;
            RequestParam param = (RequestParam)annotation;
            if (writeMethod.getParameterTypes().length > 0) {
                return new RequestParamWraper(param, writeMethod.getParameterTypes()[0]);
            }
            return new RequestParamWraper(param, null);
        }
        return null;
    }

    public static Field[] getDeclaredFields(Class clazz) throws SecurityException {
        ClassInfo classinfo = ClassUtil.getClassInfo(clazz);
        return classinfo.getDeclaredFields();
    }

    public static Field getDeclaredField(Class clazz, String name) throws SecurityException {
        ClassInfo classinfo = ClassUtil.getClassInfo(clazz);
        return classinfo.getDeclaredField(name);
    }

    public static PropertieDescription getPropertyDescriptor(Class clazz, String name) {
        ClassInfo classinfo = ClassUtil.getClassInfo(clazz);
        return classinfo.getPropertyDescriptor(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInfo getClassInfo(Class clazz) {
        ClassInfo classinfo = classInfos.get(clazz);
        if (classinfo != null) {
            return classinfo;
        }
        Object object = lock;
        synchronized (object) {
            classinfo = classInfos.get(clazz);
            if (classinfo == null) {
                classinfo = new ClassInfo(clazz);
                classInfos.put(clazz, classinfo);
            }
        }
        return classinfo;
    }

    public static Method getDeclaredMethod(Class clazz, String name) {
        ClassInfo csinfo = ClassUtil.getClassInfo(clazz);
        if (csinfo == null) {
            return null;
        }
        return csinfo.getDeclaredMethod(name);
    }

    public static Method[] getDeclaredMethods(Class target) {
        ClassInfo csinfo = ClassUtil.getClassInfo(target);
        return csinfo.getDeclaredMethods();
    }

    public static String genJavaName(String tableColumn) {
        int idx = tableColumn.indexOf(95);
        if (idx == -1) {
            return tableColumn.toLowerCase();
        }
        String tableColumn_ = tableColumn.toLowerCase();
        int length = tableColumn.length();
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = tableColumn_.charAt(i);
            if (i < idx) {
                ret.append(c);
                continue;
            }
            if (i <= idx) continue;
            if (c == '_') {
                idx = i;
                continue;
            }
            if (i == idx + 1) {
                if (idx != 0) {
                    ret.append(String.valueOf(c).toUpperCase());
                    continue;
                }
                ret.append(c);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static class ClassInfo {
        private volatile transient PropertieDescription pkProperty;
        private volatile transient List<PropertieDescription> esAnnonationProperties = new ArrayList<PropertieDescription>(10);
        private volatile transient PropertieDescription esParentProperty;
        private volatile transient PropertieDescription esIdProperty;
        private volatile transient PropertieDescription esVersionProperty;
        private volatile transient PropertieDescription esVersionTypeProperty;
        private volatile transient PropertieDescription esRetryOnConflictProperty;
        private volatile transient PropertieDescription esRoutingProperty;
        private volatile transient PropertieDescription esDocAsUpsertProperty;
        private volatile transient PropertieDescription esReturnSourceProperty;
        private volatile transient Field[] declaredFields;
        private volatile transient List<PropertieDescription> propertyDescriptors;
        private volatile transient Method[] declaredMethods;
        private volatile transient Constructor defaultConstruction;
        private volatile transient Constructor[] constructions;
        private Class<?> clazz;
        private Class<?> componentType;
        private List<Class> superClasses;
        private boolean primary;
        private boolean numeric;
        private boolean map;
        private boolean list;
        private boolean array;
        private boolean enums;
        private boolean baseprimary;
        private boolean cglib = false;
        private static final Field[] NULL = new Field[0];
        private static final Method[] NULL_M = new Method[0];
        private static final List<PropertieDescription> NULL_P = new ArrayList<PropertieDescription>();
        private Object declaredMethodLock = new Object();

        public Constructor getConstructor(Class ... paramTypes) {
            try {
                if (paramTypes == null || paramTypes.length == 0) {
                    return this.defaultConstruction;
                }
                for (int i = 0; this.constructions != null && i < this.constructions.length; ++i) {
                    int j;
                    Constructor c = this.constructions[i];
                    Class<?>[] pt = c.getParameterTypes();
                    if (pt.length != paramTypes.length) continue;
                    for (j = 0; j < pt.length && pt[j] == paramTypes[j]; ++j) {
                    }
                    if (j != pt.length) continue;
                    return c;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public PropertieDescription getPkProperty() {
            return this.pkProperty;
        }

        public void setPkProperty(PropertieDescription pkProperty) {
            this.pkProperty = pkProperty;
        }

        public String getName() {
            return this.clazz.getName();
        }

        private ClassInfo(Class clazz) {
            String name = clazz.getName();
            int idx = name.indexOf("$$EnhancerByCGLIB$$");
            if (idx < 0) {
                idx = name.indexOf("_$$_jvst");
                if (idx < 0) {
                    this.clazz = clazz;
                } else {
                    this.clazz = clazz.getSuperclass();
                    this.cglib = true;
                }
            } else {
                this.clazz = clazz.getSuperclass();
                this.cglib = true;
            }
            try {
                this.defaultConstruction = this.clazz.getDeclaredConstructor(new Class[0]);
                if (this.defaultConstruction != null) {
                    ReflectionUtils.makeAccessible(this.defaultConstruction);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.constructions = this.clazz.getDeclaredConstructors();
                for (int i = 0; this.constructions != null && i < this.constructions.length; ++i) {
                    ReflectionUtils.makeAccessible(this.constructions[i]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.init();
        }

        public void setPropertyValue(Object obj, String property, Object value) {
            try {
                this.getPropertyDescriptor(property).setValue(obj, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object getPropertyValue(Object obj, String property) {
            try {
                return this.getPropertyDescriptor(property).getValue(obj);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Method[] getDeclaredMethods() {
            if (this.declaredMethods != null) {
                if (this.declaredMethods == NULL_M) {
                    return null;
                }
                return this.declaredMethods;
            }
            Object object = this.declaredMethodLock;
            synchronized (object) {
                if (this.declaredMethods != null) {
                    if (this.declaredMethods == NULL_M) {
                        return null;
                    }
                    return this.declaredMethods;
                }
                Method[] retmethods = null;
                try {
                    retmethods = this.getRecursiveDeclaredMehtods();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                this.declaredMethods = retmethods == null ? NULL_M : retmethods;
            }
            if (this.declaredMethods == NULL_M) {
                return null;
            }
            return this.declaredMethods;
        }

        private void init() {
            this.primary = ValueObjectUtil.isPrimaryType(this.clazz);
            this.map = ValueObjectUtil.isMapType(this.clazz);
            this.list = ValueObjectUtil.isListType(this.clazz);
            this.array = ValueObjectUtil.isArrayType(this.clazz);
            this.enums = ValueObjectUtil.isEnumType(this.clazz);
            this.baseprimary = ValueObjectUtil.isBasePrimaryType(this.clazz);
            this.numeric = ValueObjectUtil.isNumeric(this.clazz);
            this.componentType = ValueObjectUtil.getComponentType(this.clazz);
            if (this.superClasses == null) {
                this.superClasses = new ArrayList<Class>();
                for (Class<?> superclass = this.clazz.getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                    this.superClasses.add(superclass);
                }
            }
            if (this.declaredFields == null) {
                Field[] retfs = null;
                try {
                    retfs = this.getRecursiveDeclaredFileds();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                List<PropertieDescription> retpropertyDescriptors = null;
                try {
                    retpropertyDescriptors = this.initBeaninfo(retfs);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    retpropertyDescriptors = NULL_P;
                }
                this.propertyDescriptors = retpropertyDescriptors;
                this.declaredFields = retfs == null ? NULL : retfs;
            }
        }

        public Field[] getDeclaredFields() {
            if (this.declaredFields == NULL) {
                return null;
            }
            return this.declaredFields;
        }

        public List<PropertieDescription> getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        private boolean issamemethod(Method method, Method other) {
            if (!method.getName().equals(other.getName())) {
                return false;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?>[] otherparameterTypes = other.getParameterTypes();
            if (!(parameterTypes != null && parameterTypes.length != 0 || otherparameterTypes != null && otherparameterTypes.length != 0)) {
                return true;
            }
            if (parameterTypes == null) {
                return false;
            }
            if (otherparameterTypes == null) {
                return false;
            }
            if (parameterTypes.length != otherparameterTypes.length) {
                return false;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i] == otherparameterTypes[i]) continue;
                return false;
            }
            return true;
        }

        private boolean containMethod(List<Method> lfs, Method method) {
            if (lfs == null || lfs.size() == 0) {
                return false;
            }
            for (Method other : lfs) {
                if (!this.issamemethod(method, other)) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Method[] getRecursiveDeclaredMehtods() {
            Method[] methods = null;
            ArrayList<Method> lfs = new ArrayList<Method>();
            Class<?> clazz_super = this.clazz;
            while (true) {
                try {
                    do {
                        if ((methods = clazz_super.getMethods()) == null || methods.length <= 0) continue;
                        for (Method f : methods) {
                            if (this.containMethod(lfs, f)) continue;
                            lfs.add(f);
                        }
                    } while ((clazz_super = clazz_super.getSuperclass()) != null && clazz_super != Object.class);
                }
                catch (Exception e) {
                    if ((clazz_super = clazz_super.getSuperclass()) != null) continue;
                }
                break;
            }
            if (lfs.size() > 0) {
                methods = new Method[lfs.size()];
                for (int i = 0; i < lfs.size(); ++i) {
                    methods[i] = (Method)lfs.get(i);
                }
            }
            return methods;
        }

        private boolean issamefield(Field field, Field other) {
            if (!field.getName().equals(other.getName())) {
                return false;
            }
            return field.getType() == other.getType();
        }

        private boolean containField(List<Field> lfs, Field field) {
            if (lfs == null || lfs.size() == 0) {
                return false;
            }
            for (Field other : lfs) {
                if (!this.issamefield(field, other)) continue;
                return true;
            }
            return false;
        }

        private Field[] getRecursiveDeclaredFileds() {
            Field[] fields = null;
            ArrayList<Field> lfs = new ArrayList<Field>();
            Class<?> clazz_super = this.clazz;
            while (true) {
                try {
                    do {
                        if ((fields = clazz_super.getDeclaredFields()) == null || fields.length <= 0) continue;
                        for (Field f : fields) {
                            if (this.containField(lfs, f)) continue;
                            lfs.add(f);
                        }
                    } while ((clazz_super = clazz_super.getSuperclass()) != null);
                }
                catch (Exception e) {
                    if ((clazz_super = clazz_super.getSuperclass()) != null) continue;
                }
                break;
            }
            if (lfs.size() > 0) {
                fields = new Field[lfs.size()];
                for (int i = 0; i < lfs.size(); ++i) {
                    fields[i] = (Field)lfs.get(i);
                }
            }
            return fields;
        }

        public Method getDeclaredMethod(String name) {
            Method[] ret = this.getDeclaredMethods();
            if (ret == null) {
                return null;
            }
            for (Method f : ret) {
                if (!f.getName().equals(name)) continue;
                return f;
            }
            return null;
        }

        public Field getDeclaredField(String name) {
            Field[] ret = this.getDeclaredFields();
            if (ret == null) {
                return null;
            }
            for (Field f : ret) {
                if (!f.getName().equals(name)) continue;
                return f;
            }
            return null;
        }

        private Field getDeclaredField(Field[] declaredFields, String name, Class type) {
            if (declaredFields == null) {
                return null;
            }
            for (int i = declaredFields.length - 1; i >= 0; --i) {
                Field f = declaredFields[i];
                if (!f.getName().equals(name) || f.getType() != type) continue;
                return f;
            }
            return null;
        }

        private List<Field> copyFields(Field[] declaredFields) {
            if (declaredFields == null || declaredFields.length == 0) {
                return null;
            }
            ArrayList<Field> copys = new ArrayList<Field>(declaredFields.length);
            for (int i = 0; i < declaredFields.length; ++i) {
                copys.add(declaredFields[i]);
            }
            return copys;
        }

        private Field containFieldAndRemove(String name, List<Field> fields) {
            for (int i = 0; fields != null && i < fields.size(); ++i) {
                Field p = fields.get(i);
                if (!p.getName().equals(name)) continue;
                fields.remove(i);
                --i;
                return p;
            }
            return null;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        private boolean containFieldInPropertyDescriptors(List<PropertieDescription> propertyDescriptors, Field field) {
            if (propertyDescriptors == null || propertyDescriptors.size() == 0) {
                return false;
            }
            for (PropertieDescription p : propertyDescriptors) {
                if (!p.getName().equalsIgnoreCase(field.getName())) continue;
                return true;
            }
            return false;
        }

        private void buildFieldPropertieDescriptions(List<PropertieDescription> propertyDescriptors, Field[] declaredFields) {
            for (int i = 0; i < declaredFields.length; ++i) {
                Field f = declaredFields[i];
                if (this.containFieldInPropertyDescriptors(propertyDescriptors, f)) continue;
                propertyDescriptors.add(this.buildPropertieDescription(f));
            }
        }

        private void buildFieldPropertieDescriptions(List<PropertieDescription> propertyDescriptors, List<Field> declaredFields) {
            for (int i = 0; i < declaredFields.size(); ++i) {
                Field f = declaredFields.get(i);
                if (this.containFieldInPropertyDescriptors(propertyDescriptors, f)) continue;
                propertyDescriptors.add(this.buildPropertieDescription(f));
            }
        }

        private List<PropertieDescription> initBeaninfo(Field[] declaredFields) {
            List<PropertieDescription> propertyDescriptors = null;
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(this.clazz);
                PropertyDescriptor[] attributes = beanInfo.getPropertyDescriptors();
                if (attributes == null || attributes.length == 0 || attributes.length == 1 && attributes[0].getName().equals("class")) {
                    if (declaredFields == null || declaredFields.length == 0) {
                        propertyDescriptors = NULL_P;
                    } else {
                        propertyDescriptors = new ArrayList<PropertieDescription>(declaredFields.length);
                        this.buildFieldPropertieDescriptions(propertyDescriptors, declaredFields);
                    }
                    return propertyDescriptors;
                }
                List<Field> copyFields = this.copyFields(declaredFields);
                propertyDescriptors = new ArrayList<PropertieDescription>();
                for (int i = 0; i < attributes.length; ++i) {
                    PropertieDescription p;
                    PropertyDescriptor attr = attributes[i];
                    if (attr.getName().equals("class") || (p = this.buildPropertieDescription(declaredFields, copyFields, attr)) == null) continue;
                    propertyDescriptors.add(p);
                }
                if (copyFields != null && copyFields.size() > 0) {
                    ArrayList<PropertieDescription> propertyDescriptors_ = new ArrayList<PropertieDescription>(declaredFields.length);
                    this.buildFieldPropertieDescriptions(propertyDescriptors_, copyFields);
                    propertyDescriptors.addAll(propertyDescriptors_);
                }
            }
            catch (Exception e) {
                propertyDescriptors = NULL_P;
                log.error("Init Beaninfo[" + this.clazz.getName() + "] failed:", (Throwable)e);
            }
            return propertyDescriptors;
        }

        private PropertieDescription buildPropertieDescription(Field[] declaredFields, List<Field> copeFields, PropertyDescriptor attr) {
            if (attr.getPropertyType() == null) {
                return null;
            }
            Method wm = attr.getWriteMethod();
            Method rm = attr.getReadMethod();
            if (rm != null && rm.getParameterTypes() != null && rm.getParameterTypes().length > 0) {
                rm = null;
            }
            if (wm != null) {
                if (wm.getParameterTypes() == null || wm.getParameterTypes().length != 1) {
                    wm = null;
                }
            } else {
                String name = attr.getName();
                String uName = name.length() == 1 ? name.substring(0, 1).toUpperCase() : name.substring(0, 1).toUpperCase() + name.substring(1);
                String wmName = "set" + uName;
                wm = this.getDeclaredMethod(wmName);
                if (wm != null) {
                    if (wm.getParameterTypes() == null || wm.getParameterTypes().length != 1) {
                        wm = null;
                    }
                    if (wm != null) {
                        boolean iswm;
                        Class<?> ptype = wm.getParameterTypes()[0];
                        boolean bl = iswm = attr.getPropertyType().isAssignableFrom(ptype) || ptype.isAssignableFrom(attr.getPropertyType());
                        if (!iswm) {
                            wm = null;
                        }
                    }
                }
            }
            Field field = this.getDeclaredField(declaredFields, attr.getName(), attr.getPropertyType());
            this.containFieldAndRemove(attr.getName(), copeFields);
            PropertieDescription pd = new PropertieDescription(this, attr.getPropertyType(), field, wm, rm, attr.getName());
            return pd;
        }

        private PropertieDescription buildPropertieDescription(Field field) {
            PropertieDescription pd = new PropertieDescription(this, field.getType(), field, null, null, field.getName());
            return pd;
        }

        public PropertieDescription getPropertyDescriptor(String name) {
            if (this.propertyDescriptors != NULL_P) {
                for (int i = 0; i < this.propertyDescriptors.size(); ++i) {
                    PropertieDescription p = this.propertyDescriptors.get(i);
                    if (!p.getName().equals(name)) continue;
                    return p;
                }
                return null;
            }
            return null;
        }

        public Constructor getDefaultConstruction() throws NoSuchMethodException {
            if (this.defaultConstruction != null) {
                return this.defaultConstruction;
            }
            throw new NoSuchMethodException(this.clazz.getName() + " do not define a default construction.");
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public boolean isBaseprimary() {
            return this.baseprimary;
        }

        public Constructor[] getConstructions() {
            return this.constructions;
        }

        public List<Class> getSuperClasses() {
            return this.superClasses;
        }

        public boolean isCglib() {
            return this.cglib;
        }

        public boolean isMap() {
            return this.map;
        }

        public void setMap(boolean map) {
            this.map = map;
        }

        public boolean isList() {
            return this.list;
        }

        public void setList(boolean list) {
            this.list = list;
        }

        public boolean isArray() {
            return this.array;
        }

        public void setArray(boolean array) {
            this.array = array;
        }

        public boolean isEnums() {
            return this.enums;
        }

        public void setEnums(boolean enums) {
            this.enums = enums;
        }

        public PropertieDescription getEsIdProperty() {
            return this.esIdProperty;
        }

        public void setEsIdProperty(PropertieDescription esIdProperty) {
            this.esIdProperty = esIdProperty;
            this.esAnnonationProperties.add(this.esIdProperty);
        }

        public PropertieDescription getEsParentProperty() {
            return this.esParentProperty;
        }

        public void setEsParentProperty(PropertieDescription esParentProperty) {
            this.esParentProperty = esParentProperty;
            this.esAnnonationProperties.add(this.esParentProperty);
        }

        public PropertieDescription getEsReturnSourceProperty() {
            return this.esReturnSourceProperty;
        }

        public PropertieDescription getEsDocAsUpsertProperty() {
            return this.esDocAsUpsertProperty;
        }

        public PropertieDescription getEsRoutingProperty() {
            return this.esRoutingProperty;
        }

        public PropertieDescription getEsRetryOnConflictProperty() {
            return this.esRetryOnConflictProperty;
        }

        public PropertieDescription getEsVersionTypeProperty() {
            return this.esVersionTypeProperty;
        }

        public PropertieDescription getEsVersionProperty() {
            return this.esVersionProperty;
        }

        public void setEsVersionProperty(PropertieDescription esVersionProperty) {
            this.esVersionProperty = esVersionProperty;
            this.esAnnonationProperties.add(this.esVersionProperty);
        }

        public void setEsVersionTypeProperty(PropertieDescription esVersionTypeProperty) {
            this.esVersionTypeProperty = esVersionTypeProperty;
            this.esAnnonationProperties.add(this.esVersionTypeProperty);
        }

        public void setEsRetryOnConflictProperty(PropertieDescription esRetryOnConflictProperty) {
            this.esRetryOnConflictProperty = esRetryOnConflictProperty;
            this.esAnnonationProperties.add(this.esRetryOnConflictProperty);
        }

        public void setEsRoutingProperty(PropertieDescription esRoutingProperty) {
            this.esRoutingProperty = esRoutingProperty;
            this.esAnnonationProperties.add(this.esRoutingProperty);
        }

        public void setEsDocAsUpsertProperty(PropertieDescription esDocAsUpsertProperty) {
            this.esDocAsUpsertProperty = esDocAsUpsertProperty;
            this.esAnnonationProperties.add(this.esDocAsUpsertProperty);
        }

        public void setEsReturnSourceProperty(PropertieDescription esReturnSourceProperty) {
            this.esReturnSourceProperty = esReturnSourceProperty;
            this.esAnnonationProperties.add(this.esReturnSourceProperty);
        }

        public List<PropertieDescription> getEsAnnonationProperties() {
            return this.esAnnonationProperties;
        }

        public boolean isNumeric() {
            return this.numeric;
        }

        public Class<?> getComponentType() {
            return this.componentType;
        }
    }

    public static class PropertieDescription {
        private Class propertyType;
        private boolean numeric;
        private Method writeMethod;
        private RequestParamWraper writeMethodRequestParam;
        private EditorInf writeMethodEditor;
        private Method readMethod;
        private Field field;
        private String name;
        private boolean canwrite = false;
        private boolean canread = false;
        private boolean canseriable = true;
        private Class[] writeMethodPropertyGenericType;
        private Class propertyGenericType;
        private Annotation[] annotations;
        private String requestParamName;
        private String origineRequestParamName;
        private boolean namevariabled = false;
        private RequestParamWraper requestParam;
        private AttributeWraper attribute;
        private PrimaryKey pk;
        private ColumnWraper column;
        private CookieValueWraper cookie;
        private RequestHeaderWraper header;
        private PathVariableWraper pathVariable;
        private RequestBodyWraper requestBody;
        private DataBind dataBind;
        private IgnoreBind ignoreBind;
        private IgnoreORMapping ignoreORMapping;
        private MapKey mapkey;
        private boolean persistentESId;
        private boolean esIdReadSet;
        private boolean persistentESParentId;
        private boolean esParentIdReadSet;
        private boolean persistentESVersion;
        private boolean persistentESVersionType;
        private boolean persistentESRetryOnConflict;
        private boolean persistentESRouting;
        private boolean persistentESDocAsUpsert;
        private boolean persistentESSource;
        private List<Var> requestParamNameToken;
        private boolean oldAccessible = false;
        private String uperName;

        public IgnoreBind getIgnoreBind() {
            return this.ignoreBind;
        }

        public RequestParamWraper getRequestParam() {
            return this.requestParam;
        }

        public boolean isNamevariabled() {
            return this.namevariabled;
        }

        public String getOrigineRequestParamName() {
            return this.origineRequestParamName;
        }

        public String toString() {
            if (this.field != null) {
                return this.field.toString();
            }
            if (this.writeMethod != null) {
                return this.writeMethod.toString();
            }
            if (this.readMethod != null) {
                return this.readMethod.toString();
            }
            return super.toString();
        }

        public PropertieDescription(ClassInfo classInfo, Class propertyType, Field field, Method writeMethod, Method readMethod, String name) {
            int mode;
            this.propertyType = propertyType;
            this.writeMethod = writeMethod;
            this.readMethod = readMethod;
            if (this.readMethod != null && !ReflectionUtils.isAccessible(readMethod)) {
                this.readMethod = null;
            }
            if (this.writeMethod != null && !ReflectionUtils.isAccessible(writeMethod)) {
                this.writeMethod = null;
            }
            this.name = name;
            if (name != null) {
                this.uperName = name.toUpperCase();
            }
            this.field = field;
            if (this.field != null) {
                this.oldAccessible = this.field.isAccessible();
            }
            if ((writeMethod == null || this.readMethod == null) && this.field != null) {
                mode = this.field.getModifiers();
                if (!Modifier.isStatic(mode)) {
                    if (!Modifier.isPublic(mode)) {
                        this.field.setAccessible(true);
                    }
                    if (!Modifier.isFinal(mode)) {
                        this.canwrite = true;
                    }
                    this.canread = true;
                }
                if (Modifier.isPublic(mode)) {
                    this.canread = true;
                    if (!Modifier.isFinal(mode)) {
                        this.canwrite = true;
                    }
                }
            }
            if (!this.canread && readMethod != null) {
                this.canread = true;
            }
            if (!this.canwrite && writeMethod != null) {
                this.canwrite = true;
            }
            if (this.field != null && (Modifier.isFinal(mode = this.field.getModifiers()) || Modifier.isStatic(mode) || Modifier.isTransient(mode) || this.findAnnotation(ExcludeField.class) != null)) {
                this.canseriable = false;
            }
            if (this.canseriable && (readMethod == null || writeMethod == null) && this.field == null) {
                this.canseriable = false;
            }
            if (this.writeMethod != null) {
                this.writeMethodPropertyGenericType = ClassUtils.getPropertyGenericTypes(writeMethod);
            } else if (field != null) {
                this.writeMethodPropertyGenericType = ClassUtils.genericTypes(this.field);
            }
            if (this.writeMethod != null) {
                this.writeMethodRequestParam = ClassUtil.getWriterMethodRequestParam(writeMethod);
                try {
                    this.writeMethodEditor = ClassUtil.getParamEditor(this.writeMethodRequestParam);
                }
                catch (Exception e) {
                    log.error("get writeMethodEditor error!", (Throwable)e);
                }
            }
            if (this.writeMethod != null) {
                this.propertyGenericType = ClassUtils.getPropertyGenericType(this.writeMethod);
            } else if (this.field != null) {
                this.propertyGenericType = ClassUtils.genericType(this.field);
            }
            if (this.field != null) {
                this.numeric = ValueObjectUtil.isNumeric(field.getType());
                this.annotations = this.field.getAnnotations();
                this.initParam(classInfo, this.annotations, field.getType());
            } else if (this.propertyType != null) {
                this.numeric = ValueObjectUtil.isNumeric(propertyType);
            }
        }

        private void initParam(ClassInfo classInfo, Annotation[] annotations, Class paramType) {
            if (annotations == null || annotations.length == 0) {
                return;
            }
            for (int i = 0; i < annotations.length; ++i) {
                Annotation a = annotations[i];
                if (a instanceof RequestParam) {
                    String name;
                    this.requestParam = new RequestParamWraper((RequestParam)a, paramType);
                    if (this.requestParam.name() == null || this.requestParam.name().equals("")) {
                        this.requestParamName = this.name;
                        break;
                    }
                    this.origineRequestParamName = name = this.requestParam.name();
                    int vstart = name.indexOf("${");
                    if (vstart < 0) {
                        this.requestParamName = name;
                        break;
                    }
                    this.namevariabled = true;
                    this.requestParamNameToken = ParameterUtil.evalVars(vstart, name);
                    break;
                }
                if (a instanceof PrimaryKey) {
                    this.pk = (PrimaryKey)a;
                    classInfo.setPkProperty(this);
                    continue;
                }
                if (a instanceof ESId) {
                    classInfo.setEsIdProperty(this);
                    this.persistentESId = ((ESId)a).persistent();
                    this.esIdReadSet = ((ESId)a).readSet();
                    continue;
                }
                if (a instanceof ESParentId) {
                    classInfo.setEsParentProperty(this);
                    this.persistentESParentId = ((ESParentId)a).persistent();
                    this.esParentIdReadSet = ((ESParentId)a).readSet();
                    continue;
                }
                if (a instanceof ESVersion) {
                    classInfo.setEsVersionProperty(this);
                    this.persistentESVersion = ((ESVersion)a).persistent();
                    continue;
                }
                if (a instanceof ESVersionType) {
                    classInfo.setEsVersionTypeProperty(this);
                    this.persistentESVersionType = ((ESVersionType)a).persistent();
                    continue;
                }
                if (a instanceof ESRetryOnConflict) {
                    classInfo.setEsRetryOnConflictProperty(this);
                    this.persistentESRetryOnConflict = ((ESRetryOnConflict)a).persistent();
                    continue;
                }
                if (a instanceof ESRouting) {
                    classInfo.setEsRoutingProperty(this);
                    this.persistentESRouting = ((ESRouting)a).persistent();
                    continue;
                }
                if (a instanceof ESDocAsUpsert) {
                    classInfo.setEsDocAsUpsertProperty(this);
                    this.persistentESDocAsUpsert = ((ESDocAsUpsert)a).persistent();
                    continue;
                }
                if (a instanceof ESSource) {
                    classInfo.setEsReturnSourceProperty(this);
                    this.persistentESSource = ((ESSource)a).persistent();
                    continue;
                }
                if (a instanceof Column) {
                    this.column = new ColumnWraper((Column)a);
                    continue;
                }
                if (a instanceof Attribute) {
                    this.attribute = new AttributeWraper((Attribute)a, paramType);
                    continue;
                }
                if (a instanceof RequestHeader) {
                    this.header = new RequestHeaderWraper((RequestHeader)a, paramType);
                    continue;
                }
                if (a instanceof PathVariable) {
                    this.pathVariable = new PathVariableWraper((PathVariable)a, paramType);
                    continue;
                }
                if (a instanceof DataBind) {
                    this.dataBind = (DataBind)a;
                    continue;
                }
                if (a instanceof RequestBody) {
                    this.requestBody = new RequestBodyWraper((RequestBody)a, this.propertyType);
                    continue;
                }
                if (a instanceof CookieValue) {
                    this.cookie = new CookieValueWraper((CookieValue)a, paramType);
                    continue;
                }
                if (a instanceof IgnoreBind) {
                    this.ignoreBind = (IgnoreBind)a;
                    continue;
                }
                if (a instanceof IgnoreORMapping) {
                    this.ignoreORMapping = (IgnoreORMapping)a;
                    continue;
                }
                if (!(a instanceof MapKey)) continue;
                this.mapkey = (MapKey)a;
            }
        }

        public Class[] getPropertyGenericTypes() {
            return this.writeMethodPropertyGenericType;
        }

        public Class getPropertyGenericType() {
            return this.propertyGenericType;
        }

        public <T extends Annotation> T findAnnotation(Class<T> type) {
            if (this.field != null) {
                return this.field.getAnnotation(type);
            }
            return null;
        }

        public boolean canread() {
            return this.canread;
        }

        public boolean canwrite() {
            return this.canwrite;
        }

        public boolean canseriable() {
            return this.canseriable;
        }

        public Object getValue(Object po) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (po == null) {
                return null;
            }
            if (this.readMethod != null) {
                return this.readMethod.invoke(po, new Object[0]);
            }
            if (this.field != null) {
                return this.field.get(po);
            }
            throw new IllegalAccessException("Get value for property[" + this.name + "] failed:get Method or field not exist");
        }

        public void setValue(Object po, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (po == null) {
                return;
            }
            if (this.writeMethod != null) {
                this.writeMethod.invoke(po, value);
            } else if (this.field != null) {
                this.field.set(po, value);
            } else {
                throw new IllegalAccessException("Set value for property[" + this.name + "] failed: set Method or field not exist.");
            }
        }

        public Class getPropertyType() {
            return this.propertyType;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public String getName() {
            return this.name;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public Field getField() {
            return this.field;
        }

        public void setWriteMethod(Method writeMethod) {
            this.writeMethod = writeMethod;
        }

        public void setReadMethod(Method readMethod) {
            this.readMethod = readMethod;
        }

        public String getRequestParamName() {
            return this.requestParamName;
        }

        public List<Var> getRequestParamNameToken() {
            return this.requestParamNameToken;
        }

        public PrimaryKey getPk() {
            return this.pk;
        }

        public ColumnWraper getColumn() {
            return this.column;
        }

        public String getUperName() {
            return this.uperName;
        }

        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        public CookieValueWraper getCookie() {
            return this.cookie;
        }

        public RequestHeaderWraper getHeader() {
            return this.header;
        }

        public AttributeWraper getAttribute() {
            return this.attribute;
        }

        public RequestParamWraper getWriteMethodRequestParam() {
            return this.writeMethodRequestParam;
        }

        public EditorInf getWriteMethodEditor() {
            return this.writeMethodEditor;
        }

        public PathVariableWraper getPathVariable() {
            return this.pathVariable;
        }

        public DataBind getDataBind() {
            return this.dataBind;
        }

        public RequestBodyWraper getRequestBody() {
            return this.requestBody;
        }

        public MapKey getMapkey() {
            return this.mapkey;
        }

        public IgnoreORMapping getIgnoreORMapping() {
            return this.ignoreORMapping;
        }

        public boolean isPersistentESId() {
            return this.persistentESId;
        }

        public boolean isPersistentESParentId() {
            return this.persistentESParentId;
        }

        public boolean isPersistentESVersion() {
            return this.persistentESVersion;
        }

        public boolean isPersistentESVersionType() {
            return this.persistentESVersionType;
        }

        public boolean isPersistentESRetryOnConflict() {
            return this.persistentESRetryOnConflict;
        }

        public boolean isPersistentESRouting() {
            return this.persistentESRouting;
        }

        public boolean isPersistentESDocAsUpsert() {
            return this.persistentESDocAsUpsert;
        }

        public boolean isPersistentESSource() {
            return this.persistentESSource;
        }

        public boolean isEsParentIdReadSet() {
            return this.esParentIdReadSet;
        }

        public boolean isEsIdReadSet() {
            return this.esIdReadSet;
        }

        public boolean isNumeric() {
            return this.numeric;
        }
    }

    public static class Var {
        private boolean isvar;
        private int position;
        private String name;

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isIsvar() {
            return this.isvar;
        }

        public void setIsvar(boolean isvar) {
            this.isvar = isvar;
        }
    }
}

