/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.console;

import com.bstek.uflo.console.handler.ServletHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UfloServlet
extends HttpServlet {
    private static final long serialVersionUID = 4869260811353088997L;
    public static final String URL = "/uflo";
    private Map<String, ServletHandler> handlerMap = new HashMap<String, ServletHandler>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        Collection handlers = applicationContext.getBeansOfType(ServletHandler.class).values();
        for (ServletHandler handler : handlers) {
            String url = handler.url();
            if (this.handlerMap.containsKey(url)) {
                throw new RuntimeException("Handler [" + url + "] already exist.");
            }
            this.handlerMap.put(url, handler);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletHandler targetHandler;
        String path = req.getContextPath() + URL;
        String uri = req.getRequestURI();
        String targetUrl = uri.substring(path.length());
        if (targetUrl.length() < 1) {
            resp.sendRedirect(req.getContextPath() + "/uflo/todo");
            return;
        }
        int slashPos = targetUrl.indexOf("/", 1);
        if (slashPos > -1) {
            targetUrl = targetUrl.substring(0, slashPos);
        }
        if ((targetHandler = this.handlerMap.get(targetUrl)) == null) {
            this.outContent(resp, "Handler [" + targetUrl + "] not exist.");
            return;
        }
        targetHandler.execute(req, resp);
    }

    private void outContent(HttpServletResponse resp, String msg) throws IOException {
        resp.setContentType("text/html");
        PrintWriter pw = resp.getWriter();
        pw.write("<html>");
        pw.write("<header><title>Uflo Console</title></header>");
        pw.write("<body>");
        pw.write(msg);
        pw.write("</body>");
        pw.write("</html>");
        pw.flush();
        pw.close();
    }
}

