/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.console.handler.impl.calendar;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.GetAllCalendarDefCommand;
import com.bstek.uflo.command.impl.GetCalendarDateCommand;
import com.bstek.uflo.console.handler.impl.RenderPageServletHandler;
import com.bstek.uflo.console.handler.impl.calendar.command.DeleteCalendarDateCommand;
import com.bstek.uflo.console.handler.impl.calendar.command.DeleteCalendarDefCommand;
import com.bstek.uflo.console.handler.impl.calendar.command.SaveCalendarDateCommand;
import com.bstek.uflo.console.handler.impl.calendar.command.SaveCalendarDefCommand;
import com.bstek.uflo.model.calendar.CalendarDate;
import com.bstek.uflo.model.calendar.CalendarDef;
import com.bstek.uflo.model.calendar.CalendarType;
import com.bstek.uflo.utils.IDGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class CalendarServletHandler
extends RenderPageServletHandler {
    private CommandService commandService;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("uflo-html/calendar.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    public void loadCalendars(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Collection coll = (Collection)this.commandService.executeCommand((Command)new GetAllCalendarDefCommand());
        this.writeObjectToJson(resp, coll);
    }

    public void loadCalendarDate(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Long calendarId = Long.valueOf(req.getParameter("id"));
        Collection coll = (Collection)this.commandService.executeCommand((Command)new GetCalendarDateCommand(calendarId.longValue()));
        this.writeObjectToJson(resp, coll);
    }

    public void saveCalendarDef(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("id");
        String name = req.getParameter("name");
        String type = req.getParameter("type");
        String desc = req.getParameter("desc");
        CalendarDef def = new CalendarDef();
        def.setDesc(desc);
        def.setName(name);
        def.setType(CalendarType.valueOf((String)type));
        if (StringUtils.isNotBlank((String)id)) {
            def.setId(Long.valueOf(id).longValue());
        } else {
            def.setId(IDGenerator.getInstance().nextId());
        }
        this.commandService.executeCommand((Command)new SaveCalendarDefCommand(def));
        this.writeObjectToJson(resp, def);
    }

    public void deleteCalendarDef(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("id");
        CalendarDef def = new CalendarDef();
        def.setId(Long.valueOf(id).longValue());
        this.commandService.executeCommand((Command)new DeleteCalendarDefCommand(def));
    }

    public void deleteCalendarDate(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("id");
        CalendarDate d = new CalendarDate();
        d.setId(Long.valueOf(id).longValue());
        this.commandService.executeCommand((Command)new DeleteCalendarDateCommand(d));
    }

    public void saveCalendarDate(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("id");
        String name = req.getParameter("name");
        String calendarId = req.getParameter("calendarId");
        String rangeStartTime = req.getParameter("rangeStartTime");
        String rangeEndTime = req.getParameter("rangeEndTime");
        String calendarDate = req.getParameter("calendarDate");
        String dayOfMonth = req.getParameter("dayOfMonth");
        String monthOfYear = req.getParameter("monthOfYear");
        String dayOfWeek = req.getParameter("dayOfWeek");
        CalendarDate d = new CalendarDate();
        if (StringUtils.isNotBlank((String)id)) {
            d.setId(Long.valueOf(id).longValue());
        } else {
            d.setId(IDGenerator.getInstance().nextId());
        }
        d.setName(name);
        d.setCalendarId(Long.valueOf(calendarId).longValue());
        d.setRangeStartTime(rangeStartTime);
        d.setRangeEndTime(rangeEndTime);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (StringUtils.isNotBlank((String)calendarDate)) {
                d.setCalendarDate(sd.parse(calendarDate));
            }
        }
        catch (ParseException e) {
            throw new ServletException((Throwable)e);
        }
        if (StringUtils.isNotBlank((String)dayOfMonth)) {
            d.setDayOfMonth(Integer.valueOf(dayOfMonth).intValue());
        }
        if (StringUtils.isNotBlank((String)monthOfYear)) {
            d.setMonthOfYear(Integer.valueOf(monthOfYear).intValue());
        }
        if (StringUtils.isNotBlank((String)dayOfWeek)) {
            d.setDayOfWeek(Integer.valueOf(dayOfWeek).intValue());
        }
        this.commandService.executeCommand((Command)new SaveCalendarDateCommand(d));
        this.writeObjectToJson(resp, d);
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public String url() {
        return "/calendar";
    }
}

