/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.console.handler.impl.list;

import com.bstek.uflo.console.handler.impl.WriteJsonServletHandler;
import com.bstek.uflo.process.node.reminder.CalendarInfo;
import com.bstek.uflo.process.node.reminder.CalendarProvider;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CalendarProviderListServletHandler
extends WriteJsonServletHandler
implements ApplicationContextAware {
    private Collection<CalendarProvider> calendarProviders = null;
    private boolean debug;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String loginUser = EnvironmentUtils.getEnvironment().getLoginUser();
        if (loginUser == null && !this.debug) {
            throw new IllegalArgumentException("Current run mode is not debug.");
        }
        this.writeObjectToJson(resp, this.buildCalendarInfos());
    }

    private List<CalendarInfo> buildCalendarInfos() {
        ArrayList<CalendarInfo> providers = new ArrayList<CalendarInfo>();
        for (CalendarProvider provider : this.calendarProviders) {
            providers.addAll(provider.getCalendarInfos());
        }
        return providers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.calendarProviders = applicationContext.getBeansOfType(CalendarProvider.class).values();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public String url() {
        return "/calendarproviderlist";
    }
}

