/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.console.handler.impl.todo;

import com.bstek.uflo.console.handler.impl.PageData;
import com.bstek.uflo.console.handler.impl.RenderPageServletHandler;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.query.HistoryTaskQuery;
import com.bstek.uflo.query.TaskQuery;
import com.bstek.uflo.service.HistoryService;
import com.bstek.uflo.service.TaskService;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class TodoServletHandler
extends RenderPageServletHandler {
    private TaskService taskService;
    private HistoryService historyService;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("uflo-html/todo.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    public void cliamTask(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String loginUsername = EnvironmentUtils.getEnvironment().getLoginUser();
        String taskId = req.getParameter("taskId");
        this.taskService.claim(Long.valueOf(taskId).longValue(), loginUsername);
    }

    public void loadTodo(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String loginUsername = EnvironmentUtils.getEnvironment().getLoginUser();
        String taskName = req.getParameter("taskName");
        int pageSize = Integer.valueOf(req.getParameter("pageSize"));
        int pageIndex = Integer.valueOf(req.getParameter("pageIndex"));
        int firstResult = (pageIndex - 1) * pageSize;
        TaskQuery query = this.taskService.createTaskQuery();
        query.addTaskState(TaskState.Created);
        query.addTaskState(TaskState.InProgress);
        query.addTaskState(TaskState.Ready);
        query.addTaskState(TaskState.Suspended);
        query.addTaskState(TaskState.Reserved);
        query.addAssignee(loginUsername).addOrderDesc("createDate").page(firstResult, pageSize);
        if (StringUtils.isNotBlank((String)taskName)) {
            query.nameLike("%" + taskName + "%");
        }
        int total = query.count();
        List tasks = (List)query.list();
        PageData pageData = new PageData(tasks, pageSize, pageIndex, total);
        this.writeObjectToJson(resp, pageData);
    }

    public void loadCliam(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String loginUsername = EnvironmentUtils.getEnvironment().getLoginUser();
        int pageSize = Integer.valueOf(req.getParameter("pageSize"));
        int pageIndex = Integer.valueOf(req.getParameter("pageIndex"));
        String taskName = req.getParameter("taskName");
        int firstResult = (pageIndex - 1) * pageSize;
        TaskQuery query = this.taskService.createTaskQuery();
        if (StringUtils.isNotBlank((String)taskName)) {
            query.nameLike("%" + taskName + "%");
        }
        query.addTaskState(TaskState.Ready).addParticipator(loginUsername).addOrderDesc("createDate").page(firstResult, pageSize);
        int total = query.count();
        List tasks = (List)query.list();
        PageData pageData = new PageData(tasks, pageSize, pageIndex, total);
        this.writeObjectToJson(resp, pageData);
    }

    public void loadHistory(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String loginUsername = EnvironmentUtils.getEnvironment().getLoginUser();
        int pageSize = Integer.valueOf(req.getParameter("pageSize"));
        int pageIndex = Integer.valueOf(req.getParameter("pageIndex"));
        String taskName = req.getParameter("taskName");
        int firstResult = (pageIndex - 1) * pageSize;
        HistoryTaskQuery query = this.historyService.createHistoryTaskQuery();
        if (StringUtils.isNotBlank((String)taskName)) {
            query.nameLike("%" + taskName + "%");
        }
        query.assignee(loginUsername).addOrderDesc("endDate").page(firstResult, pageSize);
        int total = query.count();
        List tasks = (List)query.list();
        PageData pageData = new PageData(tasks, pageSize, pageIndex, total);
        this.writeObjectToJson(resp, pageData);
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    @Override
    public String url() {
        return "/todo";
    }
}

