/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.simulator;

import com.cloudhopper.smpp.simulator.SmppSimulatorServerHandler;
import com.cloudhopper.smpp.simulator.SmppSimulatorSessionHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppSimulatorServer {
    private static final Logger logger = LoggerFactory.getLogger(SmppSimulatorServer.class);
    public static final String PIPELINE_SESSION_NAME = "session";
    private Channel serverChannel;
    private ChannelGroup sessionChannels = new DefaultChannelGroup();
    private ExecutorService bossThreadPool = Executors.newCachedThreadPool();
    private NioServerSocketChannelFactory channelFactory;
    private ServerBootstrap serverBootstrap;
    private SmppSimulatorServerHandler serverHandler;

    public SmppSimulatorServer() {
        this(Executors.newCachedThreadPool());
    }

    public SmppSimulatorServer(ExecutorService executors) {
        this.channelFactory = new NioServerSocketChannelFactory((Executor)this.bossThreadPool, (Executor)executors);
        this.serverBootstrap = new ServerBootstrap((ChannelFactory)this.channelFactory);
        this.serverHandler = new SmppSimulatorServerHandler(this.sessionChannels);
        this.serverBootstrap.setParentHandler((ChannelHandler)this.serverHandler);
    }

    public void start(int port) {
        logger.info("Simulator server starting on port " + port + "...");
        this.serverChannel = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(port));
        logger.info("Simulator server started");
    }

    public void stop() {
        logger.info("Closing all server session channels...");
        this.sessionChannels.close().awaitUninterruptibly();
        logger.info("Closing server channel...");
        this.serverChannel.close().awaitUninterruptibly();
        logger.info("Releasing server external resources...");
        this.serverBootstrap.releaseExternalResources();
        logger.info("Simulator server stopped");
    }

    public SmppSimulatorServerHandler getHandler() {
        return this.serverHandler;
    }

    public SmppSimulatorSessionHandler pollNextSession(long timeoutInMillis) throws Exception {
        SmppSimulatorSessionHandler session = this.serverHandler.getSessionQueue().poll(timeoutInMillis, TimeUnit.MILLISECONDS);
        if (session == null) {
            throw new Exception("No session created within timeout");
        }
        return session;
    }
}

