/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.util;

import com.cloudhopper.commons.util.DecimalUtil;
import com.cloudhopper.smpp.util.ConcurrentCommandStatusCounter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentCommandCounter {
    private AtomicInteger request;
    private AtomicInteger requestExpired;
    private AtomicLong requestWaitTime;
    private AtomicLong requestResponseTime;
    private AtomicLong requestEstimatedProcessingTime;
    private AtomicInteger response;
    private ConcurrentCommandStatusCounter responseCommandStatusCounter;

    public ConcurrentCommandCounter() {
        this.request = new AtomicInteger(0);
        this.requestExpired = new AtomicInteger(0);
        this.requestWaitTime = new AtomicLong(0L);
        this.requestResponseTime = new AtomicLong(0L);
        this.requestEstimatedProcessingTime = new AtomicLong(0L);
        this.response = new AtomicInteger(0);
        this.responseCommandStatusCounter = new ConcurrentCommandStatusCounter();
    }

    public ConcurrentCommandCounter(int request, int requestExpired, long requestWaitTime, long requestResponseTime, long requestEstimatedProcessingTime, int response, ConcurrentCommandStatusCounter responseCommandStatusCounter) {
        this.request = new AtomicInteger(request);
        this.requestExpired = new AtomicInteger(requestExpired);
        this.requestWaitTime = new AtomicLong(requestWaitTime);
        this.requestResponseTime = new AtomicLong(requestResponseTime);
        this.requestEstimatedProcessingTime = new AtomicLong(requestEstimatedProcessingTime);
        this.response = new AtomicInteger(response);
        this.responseCommandStatusCounter = responseCommandStatusCounter.copy();
    }

    public void reset() {
        this.request.set(0);
        this.requestExpired.set(0);
        this.requestWaitTime.set(0L);
        this.requestResponseTime.set(0L);
        this.requestEstimatedProcessingTime.set(0L);
        this.response.set(0);
        this.responseCommandStatusCounter.reset();
    }

    public ConcurrentCommandCounter createSnapshot() {
        return new ConcurrentCommandCounter(this.request.get(), this.requestExpired.get(), this.requestWaitTime.get(), this.requestResponseTime.get(), this.requestEstimatedProcessingTime.get(), this.response.get(), this.responseCommandStatusCounter);
    }

    public int getRequest() {
        return this.request.get();
    }

    public int incrementRequestAndGet() {
        return this.request.incrementAndGet();
    }

    public int getRequestExpired() {
        return this.requestExpired.get();
    }

    public int incrementRequestExpiredAndGet() {
        return this.requestExpired.incrementAndGet();
    }

    public long getRequestWaitTime() {
        return this.requestWaitTime.get();
    }

    public long addRequestWaitTimeAndGet(long waitTime) {
        return this.requestWaitTime.addAndGet(waitTime);
    }

    public long getRequestResponseTime() {
        return this.requestResponseTime.get();
    }

    public long addRequestResponseTimeAndGet(long responseTime) {
        return this.requestResponseTime.addAndGet(responseTime);
    }

    public long getRequestEstimatedProcessingTime() {
        return this.requestEstimatedProcessingTime.get();
    }

    public long addRequestEstimatedProcessingTimeAndGet(long estimatedProcessingTime) {
        return this.requestEstimatedProcessingTime.addAndGet(estimatedProcessingTime);
    }

    public int getResponse() {
        return this.response.get();
    }

    public int incrementResponseAndGet() {
        return this.response.incrementAndGet();
    }

    public ConcurrentCommandStatusCounter getResponseCommandStatusCounter() {
        return this.responseCommandStatusCounter;
    }

    public String toString() {
        StringBuilder to = new StringBuilder();
        to.append("[request=");
        to.append(this.getRequest());
        to.append(" expired=");
        to.append(this.getRequestExpired());
        to.append(" response=");
        to.append(this.getResponse());
        to.append(" avgWaitTime=");
        double avgWaitTime = 0.0;
        if (this.getResponse() > 0) {
            avgWaitTime = (double)this.getRequestWaitTime() / (double)this.getResponse();
        }
        to.append(DecimalUtil.toString((double)avgWaitTime, (int)1));
        to.append("ms avgResponseTime=");
        double avgResponseTime = 0.0;
        if (this.getResponse() > 0) {
            avgResponseTime = (double)this.getRequestResponseTime() / (double)this.getResponse();
        }
        to.append(DecimalUtil.toString((double)avgResponseTime, (int)1));
        to.append("ms avgEstimatedProcessingTime=");
        double avgEstimatedProcessingTime = 0.0;
        if (this.getResponse() > 0) {
            avgEstimatedProcessingTime = (double)this.getRequestEstimatedProcessingTime() / (double)this.getResponse();
        }
        to.append(DecimalUtil.toString((double)avgEstimatedProcessingTime, (int)1));
        to.append("ms cmdStatus=[");
        to.append(this.responseCommandStatusCounter.toString());
        to.append("]]");
        return to.toString();
    }
}

