/*
 * Decompiled with CFR 0.152.
 */
package com.coderplus.plugins;

import com.coderplus.plugins.FileSet;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="rename", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class RenameMojo
extends AbstractMojo {
    @Parameter(required=false)
    private File sourceFile;
    @Parameter(required=false)
    private File destinationFile;
    @Parameter(required=false)
    private List<FileSet> fileSets;
    @Parameter(property="copy.overWrite", defaultValue="true")
    boolean overWrite;
    @Parameter(property="copy.ignoreFileNotFoundOnIncremental", defaultValue="true")
    boolean ignoreFileNotFoundOnIncremental;
    @Component
    private MavenProject project;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Executing the copy-rename-maven-plugin");
        if (this.fileSets != null && this.fileSets.size() > 0) {
            for (FileSet fileSet : this.fileSets) {
                File srcFile = fileSet.getSourceFile();
                File destFile = fileSet.getDestinationFile();
                if (srcFile == null) continue;
                this.copy(srcFile, destFile);
            }
        } else if (this.sourceFile != null) {
            this.copy(this.sourceFile, this.destinationFile);
        } else {
            this.getLog().info((CharSequence)"No Files to process");
        }
    }

    private void copy(File srcFile, File destFile) throws MojoExecutionException {
        if (!srcFile.exists()) {
            if (this.ignoreFileNotFoundOnIncremental && this.buildContext.isIncremental()) {
                this.getLog().warn((CharSequence)("sourceFile " + srcFile.getAbsolutePath() + " not found during incremental build"));
            } else {
                this.getLog().error((CharSequence)("sourceFile " + srcFile.getAbsolutePath() + " does not exist"));
            }
        } else if (destFile == null) {
            this.getLog().error((CharSequence)"destinationFile not specified");
        } else if (destFile.exists() && destFile.isFile() == srcFile.isFile() && !this.overWrite) {
            this.getLog().error((CharSequence)(destFile.getAbsolutePath() + " already exists and overWrite not set"));
        } else {
            try {
                FileUtils.rename((File)srcFile, (File)destFile);
                this.getLog().info((CharSequence)("Renamed " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath()));
                this.buildContext.refresh(destFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not rename " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath());
            }
        }
    }
}

