/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.protocol;

public enum PacketType {
    OPEN(0),
    CLOSE(1),
    PING(2),
    PONG(3),
    MESSAGE(4),
    UPGRADE(5),
    NOOP(6),
    CONNECT(0, true),
    DISCONNECT(1, true),
    EVENT(2, true),
    ACK(3, true),
    ERROR(4, true),
    BINARY_EVENT(5, true);

    public static final PacketType[] VALUES;
    private final int value;
    private final boolean inner;

    private PacketType(int value) {
        this(value, false);
    }

    private PacketType(int value, boolean inner) {
        this.value = value;
        this.inner = inner;
    }

    public int getValue() {
        return this.value;
    }

    public static PacketType valueOf(int value) {
        for (PacketType type : VALUES) {
            if (type.getValue() != value || type.inner) continue;
            return type;
        }
        throw new IllegalStateException();
    }

    public static PacketType valueOfInner(int value) {
        for (PacketType type : VALUES) {
            if (type.getValue() != value || !type.inner) continue;
            return type;
        }
        throw new IllegalStateException();
    }

    static {
        VALUES = PacketType.values();
    }
}

